<?php

namespace core\router;

class Group
{
    protected $routes = [];
    protected $pattern;

    public function __construct(string $pattern, callable $result)
    {
        $this->pattern = $pattern;
        $this->routes[] = new Route($pattern, $result);
    }

    /**
     * @param string $pattern
     * @param callable $result
     * @return Group
     */
    public function addGroup(string $pattern, callable $result):Group
    {
        return $this->routes[] = new Group($this->pattern . $pattern, $result);
    }

    /**
     * @param string $pattern
     * @param callable $result
     * @return Route
     */
    public function addRoute(string $pattern, callable $result):Route
    {
        return $this->routes[] = new Route($this->pattern . $pattern, $result);
    }

    /**
     * @return array
     */
    public function getRoutes(): array
    {
        return $this->routes;
    }
}