<?php

namespace core;

use core\router\Group;
use core\router\Route;

class Router
{
    protected $routes = [];

    /**
     * @param Request $request
     * @return string
     */
    public function bind(Request $request)
    {
        return $this->export($this->routes, $request);
    }

    /**
     * @param array $routes
     * @param Request $request
     * @return string
     */
    protected function export(array $routes, Request $request)
    {
        foreach ($routes AS $route) {
            if ($route instanceof Group) {
                if (!$result = $this->export($route->getRoutes(), $request)) {
                    continue;
                }

                return $result;
            } else if ($route instanceof Route) {
                if (!$request->isMethod($route->getMethods())) {
                    continue;
                }

                if(!$route->hasExecuteRequest($request)) {
                    continue;
                }

                return call_user_func_array($route->getResult(), $route->getRequestPathVariables($request));
            }
        }

        return false;
    }

    /**
     * @param string $pattern
     * @param callable $result
     * @return Group
     */
    public function addGroup(string $pattern, callable $result):Group
    {
        return $this->routes[] = new Group($pattern, $result);
    }

    /**
     * @param string $pattern
     * @param callable $result
     * @return Route
     */
    public function addRoute(string $pattern, callable $result):Route
    {
        return $this->routes[] = new Route($pattern, $result);
    }
}