<?php

namespace core;

class Response extends \Configurator
{
    protected $content = '';
    protected $headers = [];
    protected $status = 200;

    /**
     * @return string|Ui
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string|Ui $content
     */
    public function setContent($content)
    {
        $this->content = $content;
    }

    /**
     * @return string[]
     */
    public function getHeaders()
    {
        return $this->headers;
    }

    /**
     * @param string[] $headers
     */
    public function setHeaders($headers)
    {
        $this->headers = $headers;
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param int $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    public function send()
    {
        http_response_code($this->status);
        foreach ($this->headers AS $header) {
            header($header, true);
        }

        exit($this->content);
    }
}