<?php

namespace core;

class Request
{
    protected $url;

    /**
     * @return Url
     */
    public function getUrl()
    {
        if (($this->url instanceof Url)) {
            return $this->url;
        }

        return new Url($this->url);
    }

    /**
     * @param $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return string
     */
    public function getMethod()
    {
        return $_SERVER['REQUEST_METHOD'];
    }

    /**
     * @return bool
     */
    public function isMethodPost(): bool
    {
        return $this->getMethod() == 'POST';
    }

    /**
     * @param string $method
     * @return bool
     */
    public function isValidMethod(string $method): bool
    {
        $method = strtoupper($method);
        switch ($method) {
            case "GET":
            case "POST":
            case "PUT":
            case "DELETE":
            case "HEAD":
            case "OPTIONS":
            case "PATCH":
                return true;
        }

        return false;
    }

    /**
     * @param array $methods
     * @return bool
     * @throws \Exception
     */
    public function isMethod(array $methods): bool
    {
        foreach ($methods AS $method) {
            if (!$this->isValidMethod($method)) {
                if (is_string($method)) {
                    throw new \Exception("Invalid HTTP method: " . $method);
                } else {
                    throw new \Exception("Invalid HTTP method: non-string");
                }
            }

            if ($method == $this->getMethod()) {
                return true;
            }
        }

        return false;
    }

    public function isHome()
    {
        return $this->getUrl() == '/';
    }
}