<?php

namespace core;

class Render
{
    protected $path;
    protected $assigned = array();

    public function __construct(string $path, array $assigned)
    {
        $this->path = $path;
        foreach ($assigned AS $name => $value) {
            $this->assign($name, $value);
        }
    }

    protected function assign($name, $value = null)
    {
        if (is_array($name)) {
            foreach ($name as $key => $value) {
                $this->assign($key, $value);
            }
            return;
        }
        if (is_scalar($name))
            $this->assigned[$name] = $value;
    }

    /**
     * @return string
     * @throws \Exception
     */
    public function display()
    {
        if (!file_exists($this->path)) {
            throw new \Exception(sprintf("Файл шаблона (%s) не найден", basename($this->path)));
        }

        extract($this->assigned);
        ob_start();
        include $this->path;
        $content = ob_get_clean();
        return (string)$content;
    }
}