<?php

namespace core;

class Module
{
    protected $variables = [];

    /**
     * Package constructor.
     * @param array $variables
     */
    public function __construct($variables = [])
    {
        $this->variables = $variables;
    }

    /**
     * @param array ...$paths
     */
    public function bind(...$paths)
    {
        extract($this->variables);
        foreach ($paths AS $path) {
            foreach (glob($path) AS $path_file) {
                if (!file_exists($path_file)) {
                    continue;
                }

                require_once $path_file;
            }
        }
    }
}