<?php

use core\ui\Page;

/**
 * Class Component
 * @property string title
 */
abstract class Component
{
    protected $config = [];

    public function __construct($config = [])
    {
        $this->config = $config;
    }

    /**
     * @param $name
     * @return bool|mixed
     */
    public function __get($name)
    {
        if (isset($this->config[$name])) {
            return $this->config[$name];
        }

        return false;
    }
}