<?php
/*
Script for: imdb.COM
Author: Zhareiv
Update date: 12-10-2019
Copyright (c) 2018 shareplus. All rights reserved.
*/

	function Data_media_Json($url){
		
		$data = array();
		
		
		preg_match_all('/vi\d{5,20}/m', $url, $video_id, PREG_SET_ORDER, 0);
        $player_url = "https://imdb.com/videoplayer/" . $video_id[0][0];
        $curl_content = PHP_SYSTEM_url_get_contents($player_url);
		preg_match_all('/window\.IMDbReactInitialState\.push\(({.+?})\);/', $curl_content, $player_json);
		$player_json = json_decode($player_json[1][0], true);
        $video_data = array_values($player_json["videos"]["videoMetadata"])[0];
		
		$data["source"]		= "imdb";
		$data["title"] = $video_data["title"];
        $data["duration"] = $video_data["duration"];
        $data["thumbnail"] = $video_data["slate"]["url"];
		
		if (!empty($video_data["encodings"])) {
            $i = 0;
            foreach ($video_data["encodings"] as $video) {
                if ($video["mimeType"] == "video/mp4") {
                    $data["data"][$i]["url"] = $video["videoUrl"];
                    $data["data"][$i]["format"] = "mp4";
                    $data["data"][$i]["size"] = PHP_file_size($data["data"][$i]["url"]);
                    if ($video["definition"] == "SD") {
                        $data["data"][$i]["quality"] = "360p";
                    } else {
                        $data["data"][$i]["quality"] = $video["definition"];
                    }
                    $i++;
                }
            }
        }
        return $data;
    }
	
?>