<?php
/*
Script for: lassovideos.com
Author: Zhareiv
Update date: 03-10-2019
Copyright (c) 2018 shareplus. All rights reserved.
*/

	function Data_media_Json($url){
		
		$data = array();
		
		$curl_content = PHP_SYSTEM_url_get_contents($url);
         
		$data["source"]		= "lasso";
        $data["title"] 		= Data_title($curl_content);
        $data["thumbnail"] 	= Data_thumbnail($curl_content);
		$sd_link = sd_finallink($curl_content);
		$data["data"]["0"]["url"] 		= str_replace_url($sd_link);
		$data["data"]["0"]["format"] 	= "mp4";
		$data["data"]["0"]["quality"] 	= 'SD';
		$data["data"]["0"]["size"] 		= PHP_file_size($data["data"][0]["url"]);
		$hd_link = hd_finallink($curl_content);
		if(!empty($hd_link)){
			$data["data"]["1"]["url"] 		= str_replace_url($hd_link);
			$data["data"]["1"]["format"] 	= "mp4";
			$data["data"]["1"]["quality"] 	= 'HD';
			$data["data"]["1"]["size"] 		= PHP_file_size($data["data"][1]["url"]);
		}
        return $data;
    }

    function Data_thumbnail($curl_content){
        if (preg_match_all('@<meta property="og:image" content="(.*?)" />@si', $curl_content, $match)) {
            return $match[1][0];
        }
    }	

	function cleanStr($str){
		return html_entity_decode(strip_tags($str), ENT_QUOTES, 'UTF-8');
	}

	function str_replace_url($url){
		$data = str_replace('\/', '/', $url);
		//$data = str_replace(':/', ':/', $url);
		return $data;
	}	

	function hd_finallink($curl_content){
        preg_match('@"hd_src":"(.*?)"@si', $curl_content, $match);
        return $match[1];
	}

	function sd_finallink($curl_content){
		preg_match('@"sd_src_no_ratelimit":"(.*?)"@si', $curl_content, $match);
		return $match[1];
	}

    function Data_title($curl_content){
        if (preg_match_all('@<meta name="description" content="(.*?)" />@si', $curl_content, $match)) {
            return $match[1][0];
        }
    }	
?>