<?php
/*
Script for: Dailymotion.com
Author: Zhareiv
Update date: 09-12-2019
Copyright (c) 2018 shareplus. All rights reserved.
*/


	function Data_media_Json($url){
		$data 			= array();
		$get_data 		= get_data($url);
		//$curl_content 	= PHP_NATIVE_cURL($get_data['url']);
		$curl_content 	= PHP_SYSTEM_url_get_contents($get_data['url']);
		$string 		= $curl_content;

		preg_match_all('/(?P<tag>#EXT-X-STREAM-INF:)|(?:(?P<prop_key>[-a-z]+)=\"(?P<prop_val>[^"]+)")|(?<something>,[^\r\n]+)|(?<url>http[^\s]+)/', $string, $match );

		$count 	= count( $match[0] );
		$result = [];
		$index 	= -1;

		for( $i =0; $i < $count; $i++ ){
			$item = $match[0][$i];

			if( !empty($match['tag'][$i])){
				//is a tag increment the result index
				++$index;
			}elseif( !empty($match['something'][$i])){
				//is a prop - split item
				$result[$index]['something'] = $item;
			}
		}

		$get_videos = get_videos($result);
		
		$data["title"] 		= $get_data['title'];
		$data["source"] 	= "dailymotion";
		$data["thumbnail"] 	= $get_data['image'];
		$i = 0;
		foreach ($get_videos['data'] as $format_id => $stream) {
			if($format_id == 1 || $format_id == 3 || $format_id == 5 || $format_id == 7 || $format_id == 9 || $format_id == 11 || $format_id == 12 || $format_id == 14){ 
				//NULL
			}else{
				$data['data'][$i]['url']		= $stream['url'];
				$data['data'][$i]['format']		= 'mp4';
				$data['data'][$i]['size']		= PHP_file_size($stream['url']);
				$data['data'][$i]['quality']	= $stream['quality'] . 'p';
			}
			$i++;
		}
		return $data;
	}
	
	function get_videos($result){
		$data = array();
		$i = 0;
		foreach ($result as $format_id => $stream) {
			preg_match('@PROGRESSIVE-URI="(.*?)"@si', $stream['something'], $video_url);
			preg_match('@NAME="(.*?)"@si', $stream['something'], $quality); 
			$data["data"][$i]["url"] 		= $video_url[1];
			$data["data"][$i]["quality"] 	= $quality[1];
			$i++;
		}
		
		return $data;
	}
	
	function get_data($url){
		$data 				= array();
		$id 				= video_id($url);
		$curl_content 		= PHP_SYSTEM_url_get_contents("https://www.dailymotion.com/embed/video/" . $id);
		$video_formats_data = get_string_between($curl_content, "config = ", "}};");	
		$video_formats_data .= "}}"; 
	 
		$video_formats_data = json_decode($video_formats_data, true);	
		$data['url'] 			= $video_formats_data['metadata']['qualities']['auto'][0]['url'];
		$data['title'] 			= $video_formats_data['metadata']['title'];
		$data['image'] 			= $video_formats_data['metadata']['posters']['720'];

		return $data;
	}
 
	function get_string_between($string, $start, $end){
        $string = ' ' . $string;
        $ini = strpos($string, $start);
        if ($ini == 0) return '';
        $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini;
        return substr($string, $ini, $len);
    } 
	
	function video_id($url){
        $domain = str_ireplace("www.", "", parse_url($url, PHP_URL_HOST));
        switch (true) {
            case($domain == "dai.ly"):
                $video_id = str_replace('https://dai.ly/', "", $url);
                $video_id = str_replace('/', "", $video_id);
                return $video_id;
                break;
            case($domain == "dailymotion.com"):
                $url_parts = parse_url($url);
                $path_arr = explode("/", rtrim($url_parts['path'], "/"));
                $video_id = $path_arr[2];
                return $video_id;
                break;
        }
    } 

?>