<?php
$this->pageTitle = 'Главная страница';
$this->pageInfo = 'Общая статистика';
?>
<div class="row">
    <div class="col-lg-3 col-md-6">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-comment fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge"><?php echo $params['chat'];?></div>
                        <div>Сообщений в чате</div>
                    </div>
                </div>
            </div>
            <a href="/chat/">
                <div class="panel-footer">
                    <span class="pull-left"><a href="/chat">Перейти</a></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="panel panel-green">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-comments fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge"><?php echo $params['support'];?></div>
                        <div>Обращений в ТП</div>
                    </div>
                </div>
            </div>
            <a href="/forum/">
                <div class="panel-footer">
                    <span class="pull-left"><a href="/panel/support/">Перейти</a></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="panel panel-yellow">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-shopping-cart fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge"><?php echo $params['money'];?></div>
                        <div>Совершено платежей</div>
                    </div>
                </div>
            </div>
            <a href="/">
                <div class="panel-footer">
                    <span class="pull-left"><a href="/panel/logs/donate">Перейти</a></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="panel panel-red">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-support fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge"><?php echo $params['users'];?></div>
                        <div>Зарегистрировано</div>
                    </div>
                </div>
            </div>
            <a href="/">
                <div class="panel-footer">
                    <span class="pull-left">Перейти</span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
</div>
<!-- /.row -->

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-bar-chart-o fa-fw"></i> Статистика регистраций</h3>
            </div>
            <div class="panel-body">
                <div id="morris-area-chart"></div>
            </div>
        </div>
    </div>
</div>
<!-- /.row -->
<script>
$(function() {
    Morris.Area({
        element: 'morris-area-chart',
        data: <?php echo $params['registrations'];?>,
        xkey: 'period',
        ykeys: ['registration'],
        labels: ['Зарегистрировано'],
        pointSize: 2,
        hideHover: 'auto',
        resize: true
    });
});
</script>
