<?php

/**
 * AddAdminForm class.
 * AddAdminForm is the data structure for keeping
 * form data while adding and updating data of users with administrator roles'.
 */
class BattlesBotsForm extends CFormModel {
    public $id_location;
    public $bots_level;
    public $bots_count1;
    public $bots_count2;
    public $id_set;
    public $quality;

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.

        return array(
            array('bots_level, bots_count1, bots_count2, id_set, quality', 'required'),
            array('id_location', 'safe'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_location' => Yii::t('layout', 'Локация'),
            'bots_level' => Yii::t('layout', 'Уровень ботов'),
            'bots_count1' => Yii::t('layout', 'Боты за Краллов'),
            'bots_count2' => Yii::t('layout', 'Боты за Элийцев'),
            'id_set' => Yii::t('layout', 'Одежда'),
            'quality' => Yii::t('layout', 'Качество'),
        );
    }

}
?>