<?php
class UsersController extends AdminBaseController {
    public function accessRules() {
        return array(
            array('allow',
                'actions' => array('index', 'search'),
                'roles' => array('moder'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionIndex() {
        $model = new Users('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Users']))
            $model->attributes = $_GET['Users'];

        $this->render('index', array(
            'model' => $model,
        ));
    }
    
    public function actionSearch() {
        $model = new Users('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Users']))
            $model->attributes = $_GET['Users'];

        $this->render('search', array(
            'model' => $model,
        ));
    }

    public function loadModel($id) {
        $model = BattlesLocations::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, Yii::t('admin_layout', 'Страница не найдена!'));
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param UserDepartments $model the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'user-departments-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
