<?php
class ShopController extends AdminBaseController {
    public function accessRules() {
        return array(
            array('allow',
                'actions' => array('index', 'search', 'avatars', 'createAvatar', 'updateAvatar', 'deleteAvatar', 'abilities', 'createAbility', 'updateAbility', 'deleteAbility'),
                'roles' => array('moder'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionAvatars() {
        $model = new ShopAvatars('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ShopAvatars']))
            $model->attributes = $_GET['ShopAvatars'];

        $this->render('avatars', ['model' => $model]);
        ));
    }    
	
	public function actionAbilities() {
        $model = new ShopAbilities('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['ShopAbilities']))
            $model->attributes = $_GET['ShopAbilities'];

        $this->render('abilities', ['model' => $model]);
    }
        $model = new Users('search');
    
    public function actionCreateAbility() {
        $model = new ShopAbilities();
        if (isset($_POST['ShopAbilities'])) {
            $model->attributes = $_POST['ShopAbilities'];
            if ($model->validate()) {
                if(!$model->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при работе с БД!'));
                }
                $model->image = CUploadedFile::getInstance($model, 'image');
                $file = $_SERVER['DOCUMENT_ROOT'] .
                        Yii::app()->urlManager->baseUrl .
                        '/images/avatars/'.$model->id_avatar.'.jpg';
                $model->image->saveAs($file);
                Yii::app()->ih
                    ->load($file)
                    ->resize(65, 65,false)
                    ->save($_SERVER['DOCUMENT_ROOT'] . '/images/avatars/'.$model->id_avatar.'.jpg');
                if (!$model->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при работе с БД!'));
                }
                echo CJSON::encode(array(
                     'status'=>'success',
                     'updateGrid'=>'avatars-grid',
                ));
                Yii::app()->end();
             }
             else {
                $error = CActiveForm::validate($model);
                if($error!='[]')
                    echo $error;
                Yii::app()->end();
             }
        }

        $this->renderPartial('avatarForm', array(
            'model' => $model,
        ));
    }
    
    public function actionUpdateAvatar($id) {
        $model = $this->loadModel($id, 'ShopAvatars');
        if (isset($_POST['ShopAvatars'])) {
            $model->attributes = $_POST['ShopAvatars'];
            if ($model->validate()) {
                if(!$model->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при работе с БД!'));
                }
                $model->image = CUploadedFile::getInstance($model, 'image');
                if ($model->image) {
                    $file = $_SERVER['DOCUMENT_ROOT'] .
                            Yii::app()->urlManager->baseUrl .
                            '/images/avatars/'.$model->id_avatar.'.jpg';
                    $model->image->saveAs($file);
                    Yii::app()->ih
                        ->load($file)
                        ->resize(65, 65,false)
                        ->save($_SERVER['DOCUMENT_ROOT'] . '/images/avatars/'.$model->id_avatar.'.jpg');
                    if (!$model->save(false)) {
                        throw new CHttpException(500, Yii::t('layout', 'Ошибка при работе с БД!'));
                    }
                }
                echo CJSON::encode(array(
                     'status'=>'success',
                     'updateGrid'=>'avatars-grid',
                ));
                Yii::app()->end();
             }
             else {
                $error = CActiveForm::validate($model);
                if($error!='[]')
                    echo $error;
                Yii::app()->end();
             }
        }

        $this->renderPartial('avatarForm', array(
            'model' => $model,
        ));
    }
    
    public function actionDeleteAvatar($id) {
        $model = $this->loadModel($id, 'ShopAvatars');
        if ($model->delete()) {
            unlink($_SERVER['DOCUMENT_ROOT'] . Yii::app()->urlManager->baseUrl . '/images/avatars/'.$id.'.jpg');
            echo 'true';
        }
        else {
            echo 'false';
        }
        Yii::app()->end();
    }
    
    public function actionIndex() {
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Users']))
            $model->attributes = $_GET['Users'];

        $this->render('index', array(
            'model' => $model,
        ));
    }
    
    public function actionSearch() {
        $model = new Users('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Users']))
            $model->attributes = $_GET['Users'];

        $this->render('search', array(
            'model' => $model,
        ));
    }

    public function loadModel($id, $model = 'model') {
        $model = $model::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, Yii::t('admin_layout', 'Страница не найдена!'));
        return $model;
    }
}
