<?php

class LogsController extends AdminBaseController {

    public function accessRules() {
        return array(
            array('allow',
                'actions' => array('index', 'donate', 'errors', 'delete'),
                'roles' => array('moder'),
            ),
            array('allow',
                'actions' => array('categories'),
                'roles' => array('admin'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }

    public function actionDonate() {
        $model = new DonateLog('search');
        $model->unsetAttributes();
        if (isset($_GET['DonateLog']))
            $model->attributes = $_GET['DonateLog'];

        $this->render('donate', array(
            'model' => $model,
        ));
    }
    
    public function actionIndex() {
        $model = new SupportMessages('search');
        $model->unsetAttributes();
        if (isset($_GET['SupportMessages']))
            $model->attributes = $_GET['SupportMessages'];

        $this->render('index', array(
            'model' => $model,
        ));
    }

    public function actionDelete($id) {
        $this->loadModel($id)->delete();

        // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
        if (!isset($_GET['ajax']))
            $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('/panel/support/index'));
    }

    public function loadModel($id, $name = 'DonateLog') {
        $model = $name::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, Yii::t('admin_layout', 'Страница не найдена!'));
        return $model;
    }
}
