<?php
class DefaultController extends AdminBaseController {
    public function accessRules() {
        return array(
            array('allow',
                'actions' => array('index', 'error'),
                'roles' => array('moder'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionIndex() {
        $today = strtotime(date('d-m-Y'));
        $params = array();
        $criteria = new CDbCriteria();
        $criteria->addCondition('t.time > '. $today);
        $params['chat'] = Chat::model()->count($criteria);
        $params['support'] = SupportMessages::model()->countByAttributes(array('status'=>0));
        $criteria = new CDbCriteria();
        $criteria->addNotInCondition('id_role', array(5,6));
        $criteria->addCondition('created > '. $today);
        $params['users'] = Users::model()->count($criteria);
        $criteria = new CDbCriteria();
        $criteria->compare('result', 1);
        $params['money'] = DonateLog::model()->count($criteria);
        $criteria = new CDbCriteria();
        $criteria->select = array('COUNT(id_user) as users', 'DATE_FORMAT(FROM_UNIXTIME(created), "%j") as period', 'created');
        $last = strtotime(date('d-m-Y', mktime(date("H"), date("i"), date("s"), date("m"), date("d")-7)));
        $criteria->addCondition('t.created > '. $last);
        $criteria->addNotInCondition('id_role', array(5,6));
        $criteria->group = 'period';
        $criteria->order = 'created DESC';
        $users = Users::model()->findAll($criteria);
        $users_array = CHtml::listData($users, 'period', 'users');
        $data = array();
        for ($i=date('z', $last)+1; date('z', $today) >= $i; $i++) {
            $key = $i+1;
            if (!empty($users_array[$key])) {
                $data[] = array(
                    'period' => date('Y-m-d', mktime(0, 0, 0, 0, $key)),
                    'registration' => $users_array[$key],
                );
            }
            else {
                $data[] = array(
                    'period' => date('Y-m-d', mktime(0, 0, 0, 0, $key)),
                    'registration' => 0,
                );
            }
        }
        $params['registrations'] = CJavaScript::encode($data);
        $this->render('index', array('params'=>$params));
    }

    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else {
                $this->layout = 'administration';
                $this->render('error', $error);
            }
        }
    }

}
