<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity {

    // Будем хранить id.
    protected $_id;

    // Данный метод вызывается один раз при аутентификации пользователя.
    public function authenticate() {
        // Необходимо получить массив ролей, которым разрешён доступ к админской части. (привязка к id_oper=5 - главная страница админки)        
        $roles_to_access = Roles::getAccessibleRolesToAdminModule();
        if($roles_to_access!=null)
        {
        foreach ($roles_to_access as $role) {
            $arr_ids[] = $role->id_role;
        }
        }
        else
        { /* тут надо придумать какую-то системную ошибку авторизации, когда доступ к админке запрещён вообще всем ролям */
          $this->errorCode = self::ERROR_USERNAME_INVALID;            
          return !$this->errorCode;
        }
        
        $user = Users::model()->find('LOWER(login)=? AND id_role IN(' . implode(",", $arr_ids) . ')', array(strtolower($this->login)));

        if (($user === null) || ($this->password !== $user->password)) {
            $this->errorCode = self::ERROR_USERNAME_INVALID;
        } else {
            // В качестве идентификатора будем использовать id, а не login,
            // как это определено по умолчанию. Обязательно нужно переопределить
            // метод getId(см. ниже).
            $this->_id = $user->id_user;

            // Далее логин нам не понадобится, зато имя может пригодится
            // в самом приложении. Используется как Yii::app()->user->name.
            // realName есть в нашей модели. У вас это может быть name, firstName
            // или что-либо ещё.
            $user->last_visit = time();
            $user->save();
            $this->errorCode = self::ERROR_NONE;
        }
        return !$this->errorCode;
    }

    public function getId() {
        return $this->_id;
    }

}
