<?php
/* @var $this UserController */
/* @var $model Users */
$this->pageTitle = ($model->id_user == Yii::app()->user->id ? 'Мой герой' : 'Герой: '.$model->login);
$params = Users::calcParam($model->id_user);
?>
<?php if (Users::checkForBan($model->id_user)):?>
<div class="info error">
    Пользователь заблокирован!<br />
    Причина: <?php echo FuncHelper::outputText($model->idBan->reason); ?><br />
    Заблокировал: <?php echo Users::getLoginWithLink($model->idBan->id_admin); ?><br />
</div> 
<?php endif; ?>

<div class="npc-view_block">
    <div class="npc-view_img">
        <img src="/images/avatars/<?php echo $model->avatar; ?>.jpg" alt="*">
    </div>
    <div class="npc-view_info">
        <?php echo $model->login; ?> [<span class="percent"><?php echo $model->level; ?> ур.</span>]<br />
        Сражается за: <span class="percent"><?php echo $model->getUserSideName(); ?></span><br />
        Класс: <span class="percent"><?php echo $model->getUserClassName(); ?></span><br />
        <?php if ($model->guild_id):?> 
            <?php echo CHtml::link(Guilds::getName($model->guild_id), array('/guild/view/', 'id' => $model->guild_id)).', '.Yii::app()->params['ranks'][$model->guild_rank]; ?>
        <?php endif; ?>
    </div>
</div>

<?php echo CHtml::link('<img src="/images/icons/clothes.png" alt="*"> Снаряжение <span class="pull-right percent">'.$count['body'].'</span>', array('/user/body/', 'id'=>$model->id_user), array('class' => 'block') )?>
<?php if ($model->id_user == Yii::app()->user->id): ?>
    <?php echo CHtml::link('<img src="/images/icons/bag.png" alt="*"> Рюкзак <span class="pull-right percent">'.$count['backpack'].' / '.$model->backpack.'</span>', '/user/backpack/', array('class' => 'block') )?>
    <?php echo CHtml::link('<img src="/images/icons/store.png" alt="*"> Сундук <span class="pull-right percent">'.$count['store'].' / '.$model->store.'</span>', '/user/store/', array('class' => 'block') )?>
	<?php echo CHtml::link('<img src="/images/icons/ability.png" alt="*"> Навыки <span class="pull-right percent">'.UsersAbilities::model()->countByAttributes(['id_user' => Yii::app()->user->id]).'</span>', ['/user/abilities', 'id' => $model->id_user], ['class' => 'block']); ?>
    <?php echo CHtml::link('<img src="/images/icons/letter.png" alt="*"> Почта', '/mail/', array('class' => 'block') )?>   
<?php elseif ($model->id_user > 0): ?>
    <?php echo CHtml::link('<img src="/images/icons/letter.png" alt="*"> Отправить почту', ['/mail/list/', 'id' => $model->id_user], array('class' => 'block') )?>
    <?php if (!$model->guild_id && $user->guild_id && $user->guild_rank >= $user->idGuild->rank_invite && $model->side == $user->side && count($user->idGuild->users) < 10): ?>
        <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Пригласить в гильдию', array('/guild/invite/', 'id' => $model->id_user), array('class' => 'block') )?>
    <?php endif; ?>		
<?php endif; ?>		

<img src="/images/icons/strength.png" alt="*"/> сила: <?php echo (isset($model->guild_buff) && $model->guild_buff_time > time() ? '<span class="percent">'.$params->totalStrength.'</span>' : $params->totalStrength); ?><br />
<img src="/images/icons/health.png" alt="*"/> здоровье: <?php echo (isset($model->guild_buff) && $model->guild_buff_time > time() ? '<span class="percent">'.$params->totalHealth.'</span>' : $params->totalHealth); ?><br />
<img src="/images/icons/energy.png" alt="*"/> энергия: <?php echo (isset($model->guild_buff) && $model->guild_buff_time > time() ? '<span class="percent">'.$params->totalEnergy.'</span>' : $params->totalEnergy); ?> <span class="percent">(<?php echo Users::getUserCritValue($params->totalEnergy);?>% крит)</span><br />
<img src="/images/icons/regeneration.png" alt="*"/> регенерация: <?php echo (isset($model->guild_buff) && $model->guild_buff_time > time() ? '<span class="percent">'.$params->totalRegeneration.'</span>' : $params->totalRegeneration); ?><br />
<img src="/images/icons/armor.png" alt="*"/> броня: <?php echo (isset($model->guild_buff) && $model->guild_buff_time > time() ? '<span class="percent">'.$params->totalArmor.'</span>' : $params->totalArmor); ?> <span class="percent">(<?php echo Users::getUserBlockValue($params->totalArmor);?>%)</span><br />
<img src="/images/icons/star_default.png" alt="*"/> сумма: <?php echo (isset($model->guild_buff) && $model->guild_buff_time > time() ? '<span class="percent">'.$params->totalSummary.'</span>' : $params->totalSummary); ?><br />
<hr>
Благославение алтаря: <?php echo (isset($model->guild_buff) && $model->guild_buff_time > time() ? '<span class="percent">+'.$model->guild_buff.'%</span>  <span class="grey">('.FuncHelper::timeToCount($model->guild_buff_time-time()).')</span>' : '<span class="grey">не активен</span>'); ?>
<?php if ($model->id_user == Yii::app()->user->id || Yii::app()->user->roleCat == 3): ?>
    <hr>
    <img src="/images/icons/dot.png" alt="*"/> деньги: <?php echo $model->money; ?><br />
    <img src="/images/icons/dot.png" alt="*"/> ресурсы: <img src="/images/icons/iron.png" alt="*"/><?php echo $model->iron; ?> <img src="/images/icons/bottle.png" alt="*"/><?php echo $model->bottles; ?><br />
<?php endif; ?>
<?php if ($model->id_user == Yii::app()->user->id || $model->level < $user->level || Yii::app()->user->roleCat == 3): ?>
    <img src="/images/icons/dot.png" alt="*"/> участие: <?php echo $model->participation; ?><br />
    <img src="/images/icons/dot.png" alt="*"/> опыт: <?php echo FuncHelper::convertXP($model->xp); ?>/<?php echo FuncHelper::convertXP($xp['max']); ?> <span class="percent">(<?php echo $xp['percent']; ?>%)</span><br />
<?php endif; ?>
<?php if ($model->id_user == Yii::app()->user->id): ?>
    <?php echo CHtml::link('<img src="/images/icons/star_white.png" alt="*"><font color="green"> Ускорить прокачку</font>', '/user/premium/', array('class' => 'block') );?>
<?php endif; ?>
<?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Статистика', array('/user/stats/', 'id' => $model->id_user), array('class' => 'block') );?>

<?php if (Yii::app()->user->roleCat == 3): ?>
    <hr>
    <img src="/images/icons/dot.png" alt="*"/> IP: <?php echo long2ip($model->ip); ?><br />
    <img src="/images/icons/dot.png" alt="*"/> UA: <?php echo $model->ua; ?><br />
    <?php if (Users::checkForBan($model->id_user)):?>
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*">Font color="green"> Разблокировать</font>', array('/user/unBan/', 'id' => $model->id_user), array('class' => 'block unban-link') )?>
    <?php else: ?>
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"><font color="red"> Блокировка</font>', array('/user/setBan/', 'id' => $model->id_user), array('class' => 'block ban-link') )?>
    <?php endif; ?>
    <div id="ban-form"></div>
<?php endif; ?>

<?php if ($model->id_user == Yii::app()->user->id): ?>
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Настройки', '/user/options/', array('class' => 'block') )?>
    <?php echo CHtml::link('<img src="/images/icons/money_gold.png" alt="*"><font color="gold"> Купить золото</font>', '/payment/', array('class' => 'block') )?>
<?php endif; ?>
