<?php
/* @var $this UserController */
/* @var $model Users */

$this->pageTitle = 'Рюкзак (' . $count['backpack'] . '/' . $model->backpack . ')';
?>
<?php echo CHtml::link('<img src="/images/icons/store.png" alt="*"> Сундук <span class="percent">(' . $count['store'] . '/' . $model->store . ')</span>', array('/user/store/'), array('class' => 'block')) ?>

<?php if ($items == null): ?>
    Ваш рюкзак пуст
<?php else: ?>
    <?php foreach ($items as $item): ?>
        <?php
        $user_item = UserItems::findUserItem($item);
        if ($user_item)
            $better = ($item->sum > $user_item->sum ? $item->sum - $user_item->sum : false);
        else
            $better = $item->sum;
        ?>
        <div class="item-view">
            <div class="item-view_img">
                <?php if ($better): ?>
                    <div class="item-view_better">
                        +<?php echo $better; ?>
                    </div>
                <?php endif; ?> 
                <img src="/images/items/<?php echo $item->img; ?>.jpg">
            </div>
            <div class="item-view_info">
                <?php echo UserItems::itemName($item->id_item); ?><br />
                <span class="small">
                    <?php echo $item->level; ?> ур<?php echo ($item->personal ? ', личный' : '.'); ?><span class="green"><?php echo (UserItems::enchantInfo($item->id_item) ? ', ' . UserItems::enchantInfo($item->id_item) : ''); ?></span>
                </span>
                <br />
                <?php if ($item->status == ITEM_IN_BACKPACK && $item->level <= $model->level): ?>
                    <?php echo CHtml::link('[надеть]', array('/item/in', 'id' => $item->id_item)); ?>
                <?php endif; ?>
                <?php if ($item->status == ITEM_IN_BACKPACK): ?>
                    <?php echo CHtml::link('[в сундук]', array('/item/store', 'id' => $item->id_item)); ?>
                <?php endif; ?>  
            </div>
        </div>
        <hr>
    <?php endforeach; ?>
<?php endif; ?>
<?php echo CHtml::link('<img src="/images/icons/star_default.png" alt="*"> Авторазбор вещей</span>', array('/user/destroy/'), array('class' => 'block')) ?>
