<script>   
    $(document).ready(function() {
        $(document).on('click', '.take', function(ev) {
            ev.preventDefault();
            var link = $(this);
            $.ajax({
                url: $(this).attr("href"),
                type: 'POST',
                dataType: 'json',
                success: function(response){
                    if (response.status == 'success') {
                        $(link).hide(1000);
                    }
                    else {
                        $(link).parent().parent().find(".response-error").addClass("error text-center").html(response.error);    
                    }
                }
            });
        });
    });
</script>
<?php
$this->pageTitle = 'Диалог с '.$whom->login;
?>
<?php if ($user->side != $whom->side && !$user->diplomat && $whom->id_role != 11): ?>
    <div class="info">Писать противоположной стороне могут только игроки со статусом "Дипломат"</div>
<?php elseif (Yii::app()->user->level < 10): ?>
    <div class="info">Писать в приват можно с 10 уровня.</div>
<?php elseif (Yii::app()->user->mute > time()): ?>
    <div class="info error">У Вас еще активно наказание "Молчание"</div>
<?php else: ?>
    <?php $this->renderPartial('_send'.$type, ['message' => $message, 'items' => $items, 'id' => $id]); ?>
<?php endif; ?>
<hr>
<?php
$this->widget('zii.widgets.CListView', array(
    'id' => 'messages',
    'dataProvider' => $messages->search($id),
    'itemView' => '_message',
    'emptyTagName' => 'div',
    'emptyText' => 'Сообщений ещё нет',
    'template' => '{items}{pager}',
    'sortableAttributes' => array('time'),
    'pager' => array(
        'class' => 'CLinkPager',
        'actionPrefix' => 'page',
        'header' => '<center>',
        'footer' => '</center>',
        'firstPageCssClass' => 'hidden',
        'prevPageLabel' => '«',
        'nextPageLabel' => '»',
        'lastPageCssClass' => 'hidden',
        'maxButtonCount' => 4,
        'htmlOptions' => array("class" => 'pagination'),
    ),
));
?>