<?php
/* @var $this GuildsController */
/* @var $model Guilds */
$this->pageTitle = '<img src="/images/icons/guild_'.$model->side.'.png" alt="*"> Легион "'.$model->name.'"';
?>
<?php if ($model->info && $user->guild_id == $model->id_guild): ?> 
    <div class="info">
        <div class="info-text"><?php echo $model->info; ?></div>
        <div class="info-sub">
            <div class="info-time">
                <?php echo Users::getLogin($model->info_creator); ?> (<?php echo FuncHelper::time_ago($model->info_time); ?>)
            </div>
        </div>
        <div class="clearfix"></div>
    </div>
<?php endif; ?>
<?php if ($user->guild_rank > 2 && $user->guild_id == $model->id_guild && Yii::app()->request->getParam('action')): ?> 
    <?php $form = $this->beginWidget('CActiveForm', array('id' => 'guild-form')); ?>
    <div class="form-group">
        <?php echo $form->labelEx($model, 'text', array('class' => 'control-label')); ?>
        <?php echo $form->textField($model, 'text', array('class' => 'form-control', 'placeholder' => 'Введите объявление')); ?>
        <?php echo $form->error($model, 'text'); ?>
    </div>
    <div class="form-group">
        <?php echo CHtml::submitButton(Yii::t('layout', 'Отправить'), array('class' => 'btn-block form-control')); ?>
    </div>
    <?php $this->endWidget(); ?>
    <hr /> 
    <?php if ($user->guild_rank == 5): ?>
        <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Настройки легиона', array('/guild/settings/', 'id' => $model->id_guild), array('class'=>'block'))?>
        <hr /> 
    <?php endif; ?>
<?php endif; ?>
<div class="npc-view_block">
    <div class="npc-view_img">
        <img src="/images/guilds/0.jpg" alt="*">
    </div>
    <div class="npc-view_info">
        Уровень: <?php echo $model->level; ?><br />
        Пренадлежит: <span class="percent"><?php echo ($model->side < 2 ? 'Краллы' : 'Элийцы'); ?></span><br />
        Опыт: <?php echo FuncHelper::convertXP($model->xp); ?>/<?php echo FuncHelper::convertXP($xp['max']); ?> <span class="percent">(<?php echo $xp['percent']; ?>%)</span>
        <?php //echo CHtml::link('<img src="/images/icons/duel.png" alt="*"> Достижения легиона', array('/guild/achievement/', 'id' => $model->id_guild) )?>
    </div>
</div>
<?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Онлайн <img src="/images/icons/'.$model->side.'_1.png" alt="/">'.$warriors.' <img src="/images/icons/'.$model->side.'_2.png" alt="/">'.$healers, array('/guild/online/', 'id' => $model->id_guild), array('class'=>'block'));?>
<?php //echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Форум легиона', array('/forum/index/', 'guild' => $model->id_guild), array('class'=>'block'))?>
<?php if ($user->guild_id == $model->id_guild): ?> 
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Тайник легиона: <img src="/images/icons/iron.png" alt="/">'.$model->iron, array('/guild/storage/', 'id' => $model->id_guild), array('class'=>'block'));?>
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Журнал легиона', array('/guild/journal/', 'id' => $model->id_guild), array('class'=>'block'));?>
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Постройки легиона', array('/guild/buildings/', 'id' => $model->id_guild), array('class'=>'block'));?>
<?php endif; ?>
<?php //echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Чат легиона', array('/chat/index/', 'guild' => $model->id_guild), array('class'=>'block'))?>

<div class="title">Участники [<?php echo count($model->users); ?>]</div>
<?php foreach ($model->users as $member): ?>
    <?php echo Users::getLoginWithLink($member->id_user) . ' ' . Yii::app()->params['ranks'][$member->guild_rank] . ' (' . FuncHelper::convertXP($member->guild_xp) . ')'; ?>
    <?php if ($user->guild_rank > 2 && $user->guild_id == $model->id_guild && Yii::app()->request->getParam('action') && $user->id_user != $member->id_user && $user->guild_rank > $member->guild_rank): ?> 
	<?php echo FuncHelper::guildActionsAccess($user, $member, $model); ?>
    <?php endif; ?>
    <br />
<?php endforeach; ?>

<?php //echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Рейтинг легиона', array('/forum/index/', 'guild' => $model->id_guild), array('class'=>'block'))?>
<hr />
<?php if ($user->guild_rank > 2 && $user->guild_id == $model->id_guild): ?>
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Управление легионом', (Yii::app()->request->getParam('action') ? array('/guild/view/', 'id' => $model->id_guild) : array('/guild/view/', 'id' => $model->id_guild, 'action'=>'moderate')), array('class'=>'block'));?>
<?php endif; ?>
<?php if ($user->guild_rank < 5 && $user->guild_id == $model->id_guild): ?>
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*"> Покинуть легион', array('/guild/exit/'), array('class'=>'block'))?>
<?php endif; ?>