<?php
/* @var $this ForumController */
/* @var $model ForumMessages */
$this->pageTitle = $theme->title;
?>
<div class="message_block">
    <div class="message_block-user">
        <div class="pull-left">[<?php echo FuncHelper::time($theme->time); ?>] <span class="user-login"><?php echo Users::getLoginWithLink($theme->id_user); ?></span>:</div>
        <div class="pull-right">
            <a href="#" class="answer_link btn btn-default btn-sm">отв</a>
        </div>
        <div class="clearfix"></div>
    </div>
    <div class="message_block-message">
        <?php if (RoleCategories::checkRoleForAdmins($theme->idUser->idRole->id_cat_role)): ?>
            <span class="text-success"><?php echo FuncHelper::outputText($theme->message); ?></span>
        <?php else: ?>
            <?php echo FuncHelper::outputText($theme->message); ?>
        <?php endif; ?>
    </div>
</div>
<div class="title">Комментарии (<?= $count; ?>)</div>
<?php if ($theme->close || $count > 499): ?>
    <div class="info">Тема закрыта для обсуждений</div>
<?php endif; ?>
<?php
$this->widget('zii.widgets.CListView', array(
    'id' => 'messages',
    'dataProvider' => $model->search($theme->id_theme),
    'itemView' => '_message',
    'emptyTagName' => 'div',
    'emptyText' => 'Комментариев нет',
    'template' => '{items}{pager}',
    'sortableAttributes' => array('time'),
    'pagerCssClass' => 'text-center',
    'pager' => array(
        'class' => 'CLinkPager',
        'actionPrefix' => 'page',
        'header' => '',
        'footer' => '',
        'firstPageCssClass' => 'first',
        'firstPageLabel' => '<<',
        'prevPageLabel' => '«',
        'nextPageLabel' => '»',
        'lastPageCssClass' => 'last',
        'lastPageLabel' => '>>',
        'maxButtonCount' => '4',
        'htmlOptions' => array("class" => 'pagination'),
    ),
));
?>

<?php if ($theme->close || $count > 499 || Yii::app()->user->level < 5): ?>
    <div class="info error">Вы не можете оставить комментарий в данной теме</div>
<?php elseif (Yii::app()->user->mute > time()): ?>
    <div class="info error">У Вас еще активно наказание "Молчание"</div>
<?php else: ?>
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'forum-form',
    ));
    ?>
    <div class="form-group">
        <?php echo $form->label($comment, 'message', array('class' => 'control-label')); ?>
        <?php if (FuncHelper::textAreaTagsForAdmin(Yii::app()->user->roleCat)): ?>
            <br />
            <?php echo FuncHelper::textAreaTagsForAdmin(Yii::app()->user->roleCat); ?>
        <?php endif; ?>
    <?php echo $form->textArea($comment, 'message', array('class' => 'form-control message', 'placeholder' => 'Введите комментарий')); ?>
        <?php echo $form->error($comment, 'message'); ?>
    </div>
    <div class="form-group">
    <?php echo CHtml::submitButton(Yii::t('layout', 'Отправить'), array('class' => 'btn-block form-control sendForm')); ?>
    </div>
    <?php $this->endWidget(); ?>
<?php endif; ?>

<?php if (Yii::app()->user->checkAccess('moder')): ?>
    <?php echo CHtml::link('<img src="/images/icons/dot.png" alt="*" /> Управление темой', array('/forum/editTheme', 'id' => $theme->id_theme), array('class' => 'block')) ?>
<?php endif; ?>
<?php echo CHtml::link('<img src="/images/icons/forum_new.png" alt="*" /> ' . $theme->idCategory->title, array('/forum/category', 'id' => $theme->id_category), array('class' => 'block')) ?>
