<?php
/* @var $this BattlesController */
/* @var $battle BattlesLocations */
$this->pageTitle = $battle->idDungeon->name_dungeon;
?>   

<?php foreach ($battle->bots as $bot): ?>
    <img src="/images/icons/dragon.png" alt="/"> <?php echo Users::getHealthInPercents($bot); ?>%
<?php endforeach; ?> 
<img src="/images/icons/0_1.png" alt="/"> <?php echo count($battle->warriors); ?>  
<img src="/images/icons/0_2.png" alt="+"> <?php echo count($battle->healers); ?> 
 <span class="grey"><?php echo FuncHelper::timeToCount(time()-$user->idDungeon->time_start, true); ?></span>
<br />
<?php if ($user->health_now > 0): ?>
    <?php if ($user->class == 1): ?>
        <?php echo CHtml::link('<img src="/images/icons/attack.png" alt="/"> Бить врагов', array('/dungeons/damageRandomEnemy'), array('class' => 'block')) ?>
        <?php if ($user->battle_target): ?>
            <?php echo CHtml::link('<img src="/images/icons/attack.png" alt="/"> Добивать ' . Users::getFullLogin($user->battle_target) . ' [' . Users::getHealthInPercents($user->idTarget) . '%]', array('/dungeons/damageLastTarget'), array('class' => 'block')) ?>
        <?php endif; ?>
    <?php else: ?>
        <?php if ($user->battle_target && $user->battle_target == Yii::app()->user->id || $user->health_now < Users::calcParam($user->id_user, 'health')): ?>
            <?php echo CHtml::link('<img src="/images/icons/heal.png" alt="+"> Лечить себя [' . Users::getHealthInPercents($user) . '%]', array('/dungeons/healSelf'), array('class' => 'block')) ?>
        <?php endif; ?>
        <?php echo CHtml::link('<img src="/images/icons/heal.png" alt="/"> Лечить союзников', array('/dungeons/healRandomFriend'), array('class' => 'block')) ?>
        <?php if ($user->battle_target && $user->battle_target != Yii::app()->user->id): ?>
            <?php echo CHtml::link('<img src="/images/icons/heal.png" alt="+"> Лечить ' . Users::getFullLogin($user->battle_target) . ' [' . Users::getHealthInPercents($user->idTarget) . '%]', array('/dungeons/healLastTarget'), array('class' => 'block')) ?>
        <?php endif; ?>
    <?php endif; ?>
    <?php if ($user->bottles > 0 && ($user->health_now < Users::calcParam($user->id_user, 'health') || $user->energy_now < Users::calcParam($user->id_user, 'energy'))): ?>
        <?php if ($user->battle_bottles_time < time()): ?>
            <?php echo CHtml::link('<img src="/images/icons/heal.png" alt="+"> Выпить эликсир', array('/dungeons/usePotion'), array('class' => 'block')) ?>
        <?php else: ?>
            <?php echo CHtml::link('<img src="/images/icons/heal.png" alt="+"> Выпить эликсир (' . ($user->battle_bottles_time - time()) . ' сек)', array('/dungeons/usePotion'), array('class' => 'block grey')) ?>
        <?php endif; ?>
    <?php endif; ?>
		<?php if (!empty($abilities)): ?>  
			<?php foreach ($abilities as $ability): ?>  
				<?php if ($ability->time_active > time()): ?>
					<?php echo CHtml::link('<img src="/images/icons/ability.png" alt="*"> '.$ability->idAbility->name_ability.' (' . ($ability->time_active - time()) . ' сек)', ['/dungeons/useAbility', 'chosen'=>$ability->chosen], ['class' => 'block text-success']); ?>
				<?php elseif ($ability->time_cooldown > time()): ?>
					<?php echo CHtml::link('<img src="/images/icons/ability.png" alt="*"> '.$ability->idAbility->name_ability.' (' . ($ability->time_cooldown - time()) . ' сек)', ['/dungeons/useAbility', 'chosen'=>$ability->chosen], ['class' => 'block grey']) ?>            
				<?php else: ?>
					<?php echo CHtml::link('<img src="/images/icons/ability.png" alt="*"> '.$ability->idAbility->name_ability, ['/dungeons/useAbility', 'chosen'=>$ability->chosen], ['class' => 'block']) ?>
				<?php endif; ?>
			<?php endforeach; ?>
		<?php endif; ?>
<?php else: ?>
    <div class="info">Вы умерли, ожидайте окончания боя</div>
    <?php echo CHtml::link('Обновить', array('/dungeons/view', 'id'=>$battle->id_dungeon), array('class' => 'block') )?>
<?php endif; ?>
<?php echo BattleHelper::battleLog($user, 2) ?>
<?php if ($user->guild_id && $user->dungeon_id > 5): ?> 
    <?php if ($chat): ?>
        <?php foreach($chat as $one):?>
        <div class="info info-small"><?php echo Users::getLoginWithLink($one->id_user); ?>: <?php echo $one->message?></div>
        <?php endforeach;?>
     <?php endif; ?>
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'chat-form',
        'htmlOptions' => array(
            'role' => 'form',
        ),
    ));
    ?>
    <div class="center-block">
        <div class="input-group">
            <?php echo $form->textField($message, 'message', array('class' => 'form-control h_36p', 'placeholder' => 'Введите сообщение')); ?>
            <span class="input-group-btn"><?php echo CHtml::submitButton(Yii::t('layout', 'ОK'), array('class' => 'btn btn-default h_36p')); ?></span>
        </div>
        <?php echo $form->error($message, 'message', array('class' => 'info error')); ?>
    </div>
    <?php $this->endWidget(); ?>
<?php endif; ?>
