<?php
$this->pageTitle = 'Чат';

$wait_check = DungeonsList::checkForWait();
$dungeon_check = BattlesDungeons::checkForBattle();
if ($wait_check) {
    echo '
    <div class="info text-center mt_10">
        <div class="pull-left">
            Пещера: ' . CHtml::link($wait_check->name_dungeon, array('/dungeons/view', 'id' => $wait_check->id_dungeon)) . ' 
        </div>
        <div class="pull-right">
            <img src="/images/icons/0_1.png" alt="/"> ' . count($wait_check->warriors) . ' <img src="/images/icons/0_2.png" alt="/"> ' . count($wait_check->healers) . '
        </div>
        <div class="clearfix"></div>
    </div>';
} elseif ($dungeon_check) {
    echo '
    <div class="info text-center mt_10">
        <div class="pull-left">
            Пещера: ' . CHtml::link($dungeon_check->idDungeon->name_dungeon, array('/dungeons/view', 'id' => $dungeon_check->id_dungeon)) . ' 
        </div>
        <div class="pull-right">
            Идет бой
        </div>
        <div class="clearfix"></div>
    </div>';
}
?>
<?php if (Yii::app()->user->level < 3): ?>
    <div class="info">Общаться в чате можно с 3 уровня.</div>
<?php elseif (Yii::app()->user->mute > time()): ?>
    <div class="info error">У Вас еще активно наказание "Молчание"</div>
<?php else: ?>
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'chat-form',
        'htmlOptions' => array(
            'role' => 'form',
        ),
    ));
    ?>
    
    <?php if ($user->guild_id): ?>  
        <div class="guilds-navi">
            <div class="col-xs-6">
                <?php echo CHtml::link('Общий', '/chat/', array('class' => 'block small-block '.($type != 'guild' ? 'active' : ''))); ?>        
            </div>
            <div class="col-xs-6">
                <?php echo CHtml::link('Легион', array('/chat/index', 'type'=>'guild'), array('class' => 'block small-block '.($type == 'guild' ? 'active' : '')));?>        
            </div>
            <div class="clearfix"></div>
        </div>
        <?php if ($type == 'guild'): ?>
            <?php echo $form->hiddenField($message, 'type', array('value' => $user->guild_id)); ?>
        <?php endif; ?>
    <?php else: ?>
        <div class="mt_10"></div>
    <?php endif; ?>

    <div class="center-block">
        <div class="input-group">
            <span class="input-group-addon"><?php echo CHtml::link('<img src="/images/icons/refresh.png">', '/chat/index', array('class' => 'update')) ?></span>
            <?php echo $form->textField($message, 'message', array('class' => 'form-control h_36p', 'placeholder' => 'Введите сообщение')); ?>
            <span class="input-group-btn"><?php echo CHtml::submitButton(Yii::t('layout', 'ОK'), array('class' => 'btn btn-default h_36p sendForm')); ?></span>
        </div>
        <?php echo $form->error($message, 'message', array('class' => 'info error')); ?>
    </div>
    <?php $this->endWidget(); ?>
<?php endif; ?>
<hr>
<?php
$this->widget('zii.widgets.CListView', array(
    'id' => 'messages',
    'dataProvider' => $model->search($type),
    'itemView' => '_message',
    'emptyTagName' => 'div',
    'emptyText' => 'Сообщений нет',
    'template' => '{items}{pager}',
    'sortableAttributes' => array('time'),
    'pager' => array(
        'class' => 'CLinkPager',
        'actionPrefix' => 'page',
        'header' => '<center>',
        'footer' => '</center>',
        'firstPageCssClass' => 'hidden',
        'prevPageLabel' => '«',
        'nextPageLabel' => '»',
        'lastPageCssClass' => 'hidden',
        'maxButtonCount' => 4,
        'htmlOptions' => array("class" => 'pagination'),
    ),
));
?>