<?php
/* @var $this AuctionController */
/* @var $model Auction */
$this->pageTitle = $model->idItem->name;
?>
<?php $this->widget('application.components.widgets.ItemView', array('item' => $model->idItem)); ?>
<hr>
<?php if ($model->id_user == Yii::app()->user->id && !$model->last): ?>
    Осталось: <?php echo $auction['timeLeft']; ?><br />
    <?php echo CHtml::link('Забрать вещь', array('/auction/back', 'id' => $model->id_auction), array('class' => 'block')) ?> 
<?php else: ?>
    <div class="pull-left">Ставка: <?php echo $auction['price']; ?></div>
    <div class="pull-right">Осталось: <?php echo $auction['timeLeft']; ?></div>
    <div class="clearfix"></div>
	<div class="col-xs-6">
		<?php if ($model->last == Yii::app()->user->id): ?>
			<div class="textlink">Ваша ставка последняя</div>
		<?php else: ?>
			<?php echo CHtml::link('Повысить до ' . $auction['step'], array('/auction/step', 'id' => $model->id_auction), array('class' => 'block')) ?>
		<?php endif; ?>
	</div>
	<div class="col-xs-6">
		<?php echo CHtml::link('Выкупить за ' . $auction['price_out'], array('/auction/out', 'id' => $model->id_auction), array('class' => 'block')) ?>
	</div>
    <div class="clearfix"></div>
    <hr>
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'auction-form',
        'htmlOptions' => array(
            'role' => 'form',
        ),
    ));
    ?>
    <?php echo $form->error($model, 'price_step_silver', array('class' => 'info error')); ?>
    <?php echo $form->error($model, 'price_step_gold', array('class' => 'info error')); ?>
    <div class="form-group mb_5">
		<?php echo $form->labelEx($model, 'price_step', array('class'=>'col-xs-12')); ?>
		<div class="col-xs-6">
			<div class="input-group input-group-xs">
			  <span class="input-group-addon"><img src="/images/icons/money_gold.png"></span>
				<?php echo $form->textField($model, 'price_step_gold', array('class' => 'form-control', 'placeholder' => 'Золото')); ?>
			</div>
		</div>
		<div class="col-xs-6">
			<div class="input-group input-group-xs">
			  <span class="input-group-addon"><img src="/images/icons/money_silver.png"></span>
				<?php echo $form->textField($model, 'price_step_silver', array('class' => 'form-control', 'placeholder' => 'Серебро')); ?>
			</div>
		</div>
		<div class="clearfix"></div>
    </div>
    <?php echo CHtml::submitButton(Yii::t('layout', 'Повысить'), array('class' => 'btn-block form-control')); ?>
    <?php $this->endWidget(); ?>
<?php endif; ?>
