<?php
/* @var $this AuctionController */
/* @var $model Auction */
$this->pageTitle = 'Аукцион вещей';
$this->widget('zii.widgets.CListView', array(
    'dataProvider' => $model->search(),
    'itemView' => '_item',
    'emptyTagName' => 'div',
    'emptyText' => 'На аукционе нет товаров.',
    'template' => '{items}<hr>{pager}',
    'pager'=>array(
        'class'=>'CLinkPager',
        'actionPrefix'=>'page',
        'header' => '<center>',
        'footer' => '</center>',
        'firstPageCssClass' => 'hidden',
        'prevPageLabel' => '«',
        'nextPageLabel' => '»',
        'lastPageCssClass' => 'hidden',
        'maxButtonCount'=>'4',
        'htmlOptions' => array("class" => 'pagination'),
    ),
));
?>
<?php
$form = $this->beginWidget('CActiveForm', array(
    'action' => Yii::app()->createUrl($this->route),
    'method' => 'post',
    'id' => 'auction-filter',
        ));
?>

<div class="form-group">
    <?php echo $form->labelEx($model, 'level', array('class' => 'col-xs-3')); ?>
    <div class="col-xs-9">
        <?php echo $form->dropDownList($model, 'level', $filter['levels'], array('class' => 'form-control', 'empty' => 'Все')); ?>
        <?php echo $form->error($model, 'level'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'type', array('class' => 'col-xs-3')); ?>
    <div class="col-xs-9">
        <?php echo $form->dropDownList($model, 'type', $filter['types'], array('class' => 'form-control', 'empty' => 'Любой')); ?>
        <?php echo $form->error($model, 'type'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'quality', array('class' => 'col-xs-3')); ?>
    <div class="col-xs-9">
        <?php echo $form->dropDownList($model, 'quality', $filter['qualities'], array('class' => 'form-control', 'empty' => 'Любой')); ?>
        <?php echo $form->error($model, 'quality'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'show', array('class' => 'col-xs-3')); ?>
    <div class="col-xs-9">
        <?php echo $form->dropDownList($model, 'show', $filter['show'], array('class' => 'form-control', 'empty' => 'Все лоты')); ?>
        <?php echo $form->error($model, 'show'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'sort', array('class' => 'col-xs-3')); ?>
    <div class="col-xs-9">
        <?php echo $form->dropDownList($model, 'sort', $filter['sort'], array('class' => 'form-control')); ?>
        <?php echo $form->error($model, 'sort'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'name', array('class' => 'col-xs-3')); ?>
    <div class="col-xs-9">
        <?php echo $form->textField($model, 'name', array('class' => 'form-control')); ?>
        <?php echo $form->error($model, 'name'); ?>
    </div>
</div>
<?php echo CHtml::submitButton(Yii::t('layout', 'Поиск'), array('class' => 'btn-block form-control')); ?>
<?php $this->endWidget(); ?>
