<?php
/* @var $this AuctionController */
/* @var $user Users */
/* @var $item UserItems */
/* @var $model Auction */
$this->pageTitle = $item->name;
?>
<div class="item-view">
    <div class="item-view_img">
        <img src="/images/items/<?php echo $item->img; ?>.jpg">
    </div>
    <div class="item-view_info">
        <img src="/images/icons/quality/<?php echo $item->quality; ?>.png"> <?php echo FuncHelper::getQuality($item->quality); ?>
        <?php if ($item->personal > 0): ?>, личный<?php endif; ?><br /> 
        <?php echo $item->name; ?><br /> 
        <?php echo FuncHelper::getType($item->type); ?>, <b><?php echo $item->level; ?></b> уровень
    </div>
</div>
<hr />
<?php foreach (FuncHelper::mainParams() as $param => $name): ?>
    <?php if ($item->$param): ?>
    <?php $percent = $param.'_percent'; ?>
        <img src="/images/icons/<?php echo $param; ?>.png"> <?php echo $name; ?>: <?php echo $item->$param; ?> <span class="percent">(<?php echo $item->$percent; ?>%)</span><br />
    <?php endif; ?>
<?php endforeach; ?>  
<hr />
<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'auction-form',
    'htmlOptions'=>array(
        'role'=>'form',
        'class'=>'form-inline'
    ),
));
?>
<?php echo $form->error($model, 'min_price', array('class' => 'info error')); ?>
<div class="form-group">
    <div class="row mb_5">
        <?php echo $form->labelEx($model, 'min_price', array('class' => 'col-xs-2')); ?>
        <div class="col-xs-5">
            <div class="input-group">
              <span class="input-group-addon"><img src="/images/icons/money_gold.png"></span>
                <?php echo $form->textField($model, 'min_price_gold', array('class' => 'form-control', 'placeholder' => 'Золото')); ?>
            </div>
        </div>
        <div class="col-xs-5">
            <div class="input-group">
              <span class="input-group-addon"><img src="/images/icons/money_silver.png"></span>
                <?php echo $form->textField($model, 'min_price_silver', array('class' => 'form-control', 'placeholder' => 'Серебро')); ?>
            </div>
        </div>
    </div>
    
    <div class="row">
        <?php echo $form->labelEx($model, 'max_price', array('class' => 'col-xs-2')); ?>
        <div class="col-xs-5">
            <div class="input-group input-group-xs">
              <span class="input-group-addon"><img src="/images/icons/money_gold.png"></span>
                <?php echo $form->textField($model, 'max_price_gold', array('class' => 'form-control', 'placeholder' => 'Золото')); ?>
            </div>
        </div>
        <div class="col-xs-5">
            <div class="input-group input-group-xs">
              <span class="input-group-addon"><img src="/images/icons/money_silver.png"></span>
                <?php echo $form->textField($model, 'max_price_silver', array('class' => 'form-control', 'placeholder' => 'Серебро')); ?>
            </div>
        </div>
    </div>
</div>
<hr />
Стоимость лота: <img src="/images/icons/money_silver.png">05 за 24 часа.
<hr />
После продажи Вы получите свои деньги за вычетом налога 5% от суммы продажы.
<?php echo CHtml::submitButton(Yii::t('layout', 'Выставить'), array('class' => 'btn-block form-control')); ?>
<?php $this->endWidget(); ?>