<?php
## Вынесу сюда проверки некоторые, чтоб не дублировать запросы
$mail_check = UsersMessages::checkNewMail();
$battle_check = Users::checkForBattle();
$guild_info_check = Guilds::checkGuildInfo();
$guild_invite_check = Users::checkForGuildInvite();
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="author" content="">
        <meta name="language" content="<?php echo Yii::app()->language; ?>" />
        <link rel="shortcut icon" href="<?php echo Yii::app()->request->baseUrl; ?>/favicon.ico">
        <link rel="apple-touch-icon" sizes="57x57" href="<?php echo Yii::app()->request->baseUrl; ?>/images/apple/apple-touch-icon-114.png" />
        <link rel="apple-touch-icon" sizes="114x114" href="<?php echo Yii::app()->request->baseUrl; ?>/images/apple/apple-touch-icon-114.png" />
        <link rel="apple-touch-icon" sizes="72x72" href="<?php echo Yii::app()->request->baseUrl; ?>/images/apple/apple-touch-icon-144.png" />
        <link rel="apple-touch-icon" sizes="144x144" href="<?php echo Yii::app()->request->baseUrl; ?>/images/apple/apple-touch-icon-144.png" />
        <link rel="apple-touch-icon-precomposed" sizes="57x57" href="<?php echo Yii::app()->request->baseUrl; ?>/images/apple/apple-touch-icon-114-precomposed.png" />
        <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo Yii::app()->request->baseUrl; ?>/images/apple/apple-touch-icon-114-precomposed.png" />
        <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo Yii::app()->request->baseUrl; ?>/images/apple/apple-touch-icon-144-precomposed.png " />
        <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo Yii::app()->request->baseUrl; ?>/images/apple/apple-touch-icon-144-precomposed.png" />

        <title><?php echo strip_tags($this->pageTitle); ?></title>
        <link href="<?php echo Yii::app()->request->baseUrl; ?>/css/bootstrap.min.css" rel="stylesheet">
        <link href="<?php echo Yii::app()->request->baseUrl; ?>/css/panel/sb-admin.css" rel="stylesheet">
        <link href="<?php echo Yii::app()->request->baseUrl; ?>/css/panel/plugins/morris.css" rel="stylesheet">
        <link href="<?php echo Yii::app()->request->baseUrl; ?>/css/panel/font-awesome-4.1.0/css/font-awesome.min.css" rel="stylesheet" type="text/css">
        <link href="<?php echo Yii::app()->request->baseUrl; ?>/css/admin.css" rel="stylesheet">
    </head>
    <body>

        <div id="wrapper">

            <!-- Navigation -->
            <nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="/">Панель управления</a>
                </div>
                <!-- Top Menu Items -->
                <ul class="nav navbar-right top-nav">
                    <?php if ($mail_check): ?>
                        <li>
                            <?php echo CHtml::link('<i class="fa fa-envelope"></i>', array('/mail/index', 'sort' => 'new')) ?>
                        </li>
                    <?php endif; ?>
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user"></i> <?php echo Yii::app()->user->login; ?> <b class="caret"></b></a>
                        <ul class="dropdown-menu">
                            <li>
                                <?php echo CHtml::link('<i class="fa fa-fw fa-user"></i> Мой герой', '/user/') ?>
                            </li>
                            <?php if (Users::checkForGuild()): ?>  
                                <li>
                                    <?php echo CHtml::link('<i class="fa fa-fw fa-users"></i> Моя гильдия', '/guild/') ?>    
                                </li>
                            <?php endif; ?>
                            <li>
                                <?php echo CHtml::link('<i class="fa fa-fw fa-mail-forward"></i> В игру', '/') ?>        
                            </li>
                            <li class="divider"></li>
                            <li>
                                <?php echo CHtml::link('<i class="fa fa-fw fa-power-off"></i> Выйти', '/logout/') ?>  
                            </li>
                        </ul>
                    </li>
                </ul>
                <!-- Sidebar Menu Items - These collapse to the responsive navigation menu on small screens -->
                <div class="collapse navbar-collapse navbar-ex1-collapse">
                    <ul class="nav navbar-nav side-nav">
                        <li class="active">
                            <?php echo CHtml::link('<i class="fa fa-fw fa-dashboard"></i> Главная', '/panel/') ?>
                        </li>
                        <li>
                            <a href="#" data-toggle="collapse" data-target="#users"><i class="fa fa-fw fa-dot-circle-o"></i> Пользователи <i class="fa fa-fw fa-caret-down"></i></a>
                            <ul id="users" class="collapse">
                                <li><?php echo CHtml::link('Совпадения по IP', '/panel/users/') ?></li>
                            </ul>
                        </li>
                        <li>
                            <?php echo CHtml::link('<i class="fa fa-fw fa-dot-circle-o"></i> Акции', '/panel/actions/') ?>
                        </li>
                        <li>
                            <a href="#" data-toggle="collapse" data-target="#shop"><i class="fa fa-fw fa-dot-circle-o"></i> Магазины <i class="fa fa-fw fa-caret-down"></i></a>
                            <ul id="shop" class="collapse">
                                <li><?php echo CHtml::link('Магазин навыков', '/panel/shop/abilities/') ?></li>
                                <li><?php echo CHtml::link('Магазин аватаров', '/panel/shop/avatars/') ?></li>
                            </ul>
                        </li>
                        <li>
                            <a href="#" data-toggle="collapse" data-target="#battles"><i class="fa fa-fw fa-dot-circle-o"></i> Битвы <i class="fa fa-fw fa-caret-down"></i></a>
                            <ul id="battles" class="collapse">
                                <li><?php echo CHtml::link('Управление ботами', '/panel/battles/') ?></li>
                                <li><a href="#">Статистика доминации</a></li>
                            </ul>
                        </li>
                        <li>
                            <a href="#" data-toggle="collapse" data-target="#logs"><i class="fa fa-fw fa-dot-circle-o"></i> Логи <i class="fa fa-fw fa-caret-down"></i></a>
                            <ul id="logs" class="collapse">
                                <li><?php echo CHtml::link('Логи пополнений', '/panel/logs/donate/') ?></li>
                                <li><?php echo CHtml::link('Логи ошибок', '/panel/logs/errors/') ?></li>
                            </ul>
                        </li>
                        <li>
                            <a href="#" data-toggle="collapse" data-target="#support"><i class="fa fa-fw fa-dot-circle-o"></i> Тех.поддержка <i class="fa fa-fw fa-caret-down"></i></a>
                            <ul id="support" class="collapse">
                                <li><?php echo CHtml::link('Типы запросов', '/panel/support/categories/') ?></li>
                                <li><?php echo CHtml::link('Список запросов', '/panel/support/') ?></li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <!-- /.navbar-collapse -->
            </nav>

            <div id="page-wrapper">
                <div class="container-fluid">
                    <?php if (Yii::App()->user->hasFlash('success')): ?>
                        <div class="alert alert-success">
                            <?php echo Yii::App()->user->getFlash('success'); ?>
                        </div> 
                    <?php endif; ?>

                    <?php if (Yii::App()->user->hasFlash('error')): ?>
                        <div class="alert alert-error">
                            <?php echo Yii::App()->user->getFlash('error'); ?>
                        </div> 
                    <?php endif; ?>
                    <!-- Page Heading -->
                    <div class="row">
                        <div class="col-lg-12">
                            <h1 class="page-header">
                                <?php echo $this->pageTitle; ?> <small><?php echo $this->pageInfo; ?></small>
                            </h1>
                            <!--                        <ol class="breadcrumb">
                                                        <li class="active">
                                                            <i class="fa fa-dashboard"></i> Dashboard
                                                        </li>
                                                    </ol>-->
                        </div>
                    </div>
                    <!-- /.row -->
                    <?php echo $content; ?>
                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- /#page-wrapper -->

        </div>
        <!-- /#wrapper -->
        <!-- Отображение модалки -->
        <div class="modal modal-class fade"></div>
        <!-- Bootstrap core JavaScript
        ================================================== -->
        <!-- Placed at the end of the document so the pages load faster -->
        <?php Yii::app()->clientScript->registerCoreScript('jquery'); ?>
        <script src="<?php echo Yii::app()->request->baseUrl; ?>/js/bootstrap.min.js"></script>
        <script src="<?php echo Yii::app()->request->baseUrl; ?>/js/main.js"></script>
        <!-- Morris Charts JavaScript -->
        <script src="<?php echo Yii::app()->request->baseUrl; ?>/js/plugins/morris/raphael.min.js"></script>
        <script src="<?php echo Yii::app()->request->baseUrl; ?>/js/plugins/morris/morris.min.js"></script>
        <script>
        $(function () {
            $("[data-toggle=\'tooltip\']").tooltip();
            $("[data-toggle=\'popover\']").popover();
            $("[data-toggle=\'collapse\']").collapse();
        });
        </script>
    </body>
</html>