<?php
    $this->pageTitle = 'Акции';
    $this->pageInfo = 'Создание/Редактирование акции';
?>
<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'enableAjaxValidation' => false,
    'htmlOptions' => array('class' => 'form-horizontal'),
));
?>
<div class="form-group">
    <?php echo $form->labelEx($model, 'short_name_action', array('class' => 'col-sm-2 control-label')); ?>
    <div class="col-sm-8">	
        <?php echo $form->textField($model, 'short_name_action', array('class' => 'form-control')); ?>
        <?php echo $form->error($model, 'short_name_action'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'name_action', array('class' => 'col-sm-2 control-label')); ?>
    <div class="col-sm-8">	
        <?php echo $form->textField($model, 'name_action', array('class' => 'form-control')); ?>
        <?php echo $form->error($model, 'name_action'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'descr_action', array('class' => 'col-sm-2 control-label')); ?>
    <div class="col-sm-8">	
        <?php
        $this->widget('ext.tinymce.Tiny', array(
            'model' => $model,
            'attribute' => 'descr_action',
            'htmlOptions' => array(
                'class' => 'form-control',
            ),
        ));
        ?>
        <?php echo $form->error($model, 'descr_action'); ?>
    </div>
</div>
<div class="form-group">
    <?php echo $form->labelEx($model, 'type_action', array('class' => 'col-sm-2 control-label')); ?>
    <div class="col-sm-8">
        <?php echo $form->dropDownList($model, 'type_action', $types, array('class' => 'form-control')); ?>
        <?php echo $form->error($model, 'type_action'); ?>
    </div>
</div>
<div class="form-group">
    <?php echo $form->labelEx($model, 'min_bonus', array('class' => 'col-sm-2 control-label')); ?>
    <div class="col-sm-8">
        <div class="input-group">
          <?php echo $form->numberField($model, 'min_bonus', array('class' => 'form-control', 'min'=>0, 'max'=>1000)); ?>
          <span class="input-group-addon">%</span>
        </div>
        <?php echo $form->error($model, 'min_bonus'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'bonus', array('class' => 'col-sm-2 control-label')); ?>
    <div class="col-sm-8">
        <div class="input-group">
          <?php echo $form->numberField($model, 'bonus', array('class' => 'form-control', 'min'=>0, 'max'=>1000)); ?>
          <span class="input-group-addon">%</span>
        </div>
        <?php echo $form->error($model, 'bonus'); ?>
    </div>
</div>

<div class="form-group">
    <?php echo $form->labelEx($model, 'time_active', array('class' => 'col-sm-2 control-label')); ?>
    <div class="col-sm-8">
        <?php echo $form->numberField($model, 'time_active', array('class' => 'form-control', 'min'=>1)); ?>
        <?php echo $form->error($model, 'time_active'); ?>
    </div>
</div>
<div class="form-group">
    <div class="col-sm-offset-2 col-sm-8">
        <?php echo CHtml::submitButton(Yii::t('admin_layout', 'Сохранить'), array('class' => 'btn btn-info')); ?>
    </div>
</div>
<?php $this->endWidget(); ?>