<?php
class OperationsInRolesController extends AdminBaseController {
    
    public function actionIndex() {
        $this->layout = "/layouts/grid";
        $controllers = Controllers::model()->findAll();
        $modules = Modules::model()->findAll();
        $operations = Operations::findAllByAppParams();
        $roles = Roles::findAllUsers();
        //$roles = Roles::findAllIfItIsSuperAdminOrExceptSuperAdmins();

        $this->render('index', array('controllers' => $controllers, 'operations' => $operations, 'roles' => $roles, 'modules' => $modules));
    }

    public function actionToggleOperationInRole($id_oper, $id_role) {
        $access = OperationsInRoles::model()->findByPk(array('id_role' => $id_role, 'id_oper' => $id_oper));
        if ($access != null) {
            if ($access->idRole->idCat->id_cat_role == 5) {
                $can_change_access = false;
            } else {
                $can_change_access = true;
            }
            
            if ($can_change_access) {
                if ($access->delete()) {
                    echo "success";
                } else {
                    throw new CHttpException(500, 'Произошла ошибка при удалении доступа к операции!');
                }
            } else {
                throw new CHttpException(500, 'Нехороший дядя! Зачем систему ломаешь? Зачем к суперадмину лезешь? Утютю! За тобой уже выехали! И айпишник твой уже у нас в базе!');
            }
        } else {
            if (Roles::model()->findByPk($id_role)->idCat->id_cat_role == 5) {
                $can_change_access = false;
            } else {
                $can_change_access = true;
            }
            
            if ($can_change_access) {
                $access = new OperationsInRoles();
                $access->id_oper = $id_oper;
                $access->id_role = $id_role;
                if ($access->save(false)) {
                    echo "success";
                } else {
                    throw new CHttpException(500, 'Произошла ошибка при добавлении доступа к операции!');
                }
            } else {
                throw new CHttpException(500, 'Нехороший дядя! Зачем систему ломаешь? Зачем к суперадмину лезешь? Утютю! За тобой уже выехали! И айпишник твой уже у нас в базе!');
            }
        }
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer $id the ID of the model to be loaded
     * @return Roles the loaded model
     * @throws CHttpException
     */
    public function loadModel($id) {
        $model = OperationsInRoles::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, Yii::t('admin_layout', 'Страница не найдена!'));
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param Roles $model the model to be validated
     */
    protected function performAjaxValidation($model) {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'operations-in-roles-form') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

}
