<?php
class ActionsController extends AdminBaseController {
    public function accessRules() {
        return array(
            array('allow',
                'actions' => array('index', 'active', 'create', 'update', 'delete'),
                'roles' => array('moder'),
            ),
            array('deny',
                'users' => array('*'),
                'deniedCallback' => array(Yii::app()->controller, 'redirectToHome'),
            )
        );
    }
    
    public function actionIndex() {
        $model = new Actions('search');
        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Actions']))
            $model->attributes = $_GET['Actions'];

        $this->render('index', array(
            'model' => $model,
        ));
    }
    
    public function actionCreate() {
        $model = new Actions();
        $types = [
            1 => 'Бонусное золото',
            2 => 'Бонусный опыт',
            3 => 'Бонусный к.о.',
            4 => 'Премиум в подарок'
        ];
        if (isset($_POST['Actions'])) {
            $model->attributes = $_POST['Actions'];
            if ($model->validate()) {
                if(!$model->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при работе с БД!'));
                }
                else {
                   $this->redirect(array('index')); 
                }
                Yii::app()->end();
             }
        }

        $this->render('form', ['model' => $model, 'types' => $types]);
    }

    public function actionUpdate($id) {
        $model = $this->loadModel($id);
        $types = [
            1 => 'Бонусное золото',
            2 => 'Бонусный опыт',
            3 => 'Бонусный к.о.',
            4 => 'Премиум в подарок'
        ];
        if (isset($_POST['Actions'])) {
            $model->attributes = $_POST['Actions'];
            if ($model->validate()) {
                if(!$model->save(false)) {
                    throw new CHttpException(500, Yii::t('layout', 'Ошибка при работе с БД!'));
                }
                else {
                   $this->redirect(array('index')); 
                }
            }
        }
        $this->render('form', ['model' => $model, 'types' => $types]);
    }
    
    public function actionActive($id) {
        $model = $this->loadModel($id);
        $model->time = time() + $model->time_active*60*60;
        if(!$model->save(false)) {
            echo 'false';
        }
        else {
            echo 'true';
        }
        Yii::app()->end();
    }
    
    public function actionDelete($id) {
        $model = $this->loadModel($id);
        if ($model->delete()) {
            echo 'true';
        }
        else {
            echo 'false';
        }
        Yii::app()->end();
    }

    public function loadModel($id) {
        $model = Actions::model()->findByPk($id);
        if ($model === null)
            throw new CHttpException(404, Yii::t('admin_layout', 'Страница не найдена!'));
        return $model;
    }
}
