<?php

class UsersMessages extends CActiveRecord {

    public function tableName() {
        return 'users_messages';
    }

    public function rules() {
        return array(
            array('id_dialog, id_user, type, money, iron, bottles, item, time, status', 'required'),
            array('type, status', 'numerical', 'integerOnly' => true),
            array('id_dialog, id_user', 'length', 'max' => 10),
            array('message', 'length', 'max' => 1024),
            array('money, iron, bottles, item, time', 'length', 'max' => 11),
            array('id_message, id_dialog, id_user, type, message, money, iron, bottles, item, time, status', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
            'idDialog' => array(self::BELONGS_TO, 'UsersDialogs', 'id_dialog'),
            'users' => array(self::MANY_MANY, 'Users', 'users_messages_for_users(id_message, id_user)'),
        );
    }

    public function attributeLabels() {
        return array(
            'id_message' => 'Id Message',
            'id_dialog' => 'Id Dialog',
            'id_user' => 'Id User',
            'type' => 'Type',
            'message' => 'Message',
            'money' => 'Money',
            'iron' => 'Iron',
            'bottles' => 'Bottles',
            'item' => 'Item',
            'time' => 'Time',
            'status' => 'Status',
        );
    }
    
    protected function beforeSave() {
        if ($this->isNewRecord) {
            $this->time = time();
            $this->status = 1;
        }
        return parent::beforeSave();
    }
    
    public function behaviors() {
        return array('CAdvancedArBehavior' => array(
            'class' => 'application.extensions.CAdvancedArBehavior.CAdvancedArBehavior'));
    }
    
    /**
     * Проверяет есть ли у пользователя новая почта
     * @param int $id
     * @return int
     */
    public static function checkNewMail() {
        if (!Yii::app()->user->isGuest) {
            $criteria = new CDbCriteria();
            $criteria->with = array('users');
            $criteria->compare('users.id_user', Yii::app()->user->id);
            $criteria->compare('t.status', 1);
            return self::model()->count($criteria);
        }
        return false;
    }
    
    public function search($id_user = null) {
        $criteria = new CDbCriteria;
        $criteria->compare('id_dialog', $this->id_dialog);
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'sortVar' => 'sort',
                'defaultOrder' => 'time DESC',
            ),
            'pagination' => array(
                'route' => '/mail/list/',
                'params' => array('id'=>$id_user),
                'pageVar' => 'page',
                'pageSize' => '10',
            ),
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
