<?php

class UsersBuffs extends CActiveRecord {

    public function tableName() {
        return 'users_buffs';
    }

    public function rules() {
        return array(
            array('type', 'numerical', 'integerOnly' => true),
            array('id_user, strength, armor, health, energy, regeneration, time', 'length', 'max' => 11),
            array('id_buff, id_user, type, subtype, strength, armor, health, energy, regeneration, time', 'safe'),
        );
    }

    public function relations() {
        return array(
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
        );
    }

    public function attributeLabels() {
        return array(
            'id_buff' => 'Id Buff',
            'id_user' => 'Id User',
            'type' => 'Type',
            'strength' => 'Strength',
            'armor' => 'Armor',
            'health' => 'Health',
            'energy' => 'Energy',
            'regeneration' => 'Regeneration',
            'time' => 'Time',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_buff', $this->id_buff, true);
        $criteria->compare('id_user', $this->id_user, true);
        $criteria->compare('type', $this->type);
        $criteria->compare('strength', $this->strength, true);
        $criteria->compare('armor', $this->armor, true);
        $criteria->compare('health', $this->health, true);
        $criteria->compare('energy', $this->energy, true);
        $criteria->compare('regeneration', $this->regeneration, true);
        $criteria->compare('time', $this->time, true);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Ищет активный баф у юзера
     * @param type $id_building
     * @return type
     */
    public static function findByBuilding($id_building) {
        $criteria = new CDbCriteria;
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->compare('type', 1);
        $criteria->compare('subtype', $id_building);
        return self::model()->find($criteria);
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
