<?php
class UsersAbilities extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'users_abilities';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_user, id_ability, id_type, time_active, time_cooldown', 'required'),
			array('chosen', 'numerical', 'integerOnly'=>true),
			array('id_user, id_ability, id_type, time_active, time_cooldown', 'length', 'max'=>11),
			array('chosen', 'safe'),
			array('id, id_user, id_ability, id_type, chosen, time_active, time_cooldown', 'safe', 'on'=>'search'),
		);
	}

	public function relations()
	{
		return array(
			'idAbility' => array(self::BELONGS_TO, 'ShopAbilities', 'id_ability'),
			'idType' => array(self::BELONGS_TO, 'ShopAbilitiesTypes', 'id_type'),
			'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_user' => 'Id User',
			'id_ability' => 'Id Ability',
			'id_type' => 'Id Type',
			'chosen' => 'Chosen',
			'time_active' => 'Time Active',
			'time_cooldown' => 'Time Cooldown',
		);
	}

	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('id_user',$this->id_user,true);
		$criteria->compare('id_ability',$this->id_ability,true);
		$criteria->compare('id_type',$this->id_type,true);
		$criteria->compare('chosen',$this->chosen);
		$criteria->compare('time_active',$this->time_active,true);
		$criteria->compare('time_cooldown',$this->time_cooldown,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
