<?php

class UserStatistic extends CActiveRecord {

    const KU = 'killed_users';
    const KB = 'killed_bots';
    const KM = 'killed_beasts';
    const UP = 'use_potions';
    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'user_statistic';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id_user', 'required'),
            array('id_user, killed_users, killed_bots, killed_beasts, use_potions', 'length', 'max' => 11),
            array('killed_users, killed_bots, killed_beasts, use_potions', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_user' => 'Id User',
            'killed_users' => 'Killed Users',
            'killed_bots' => 'Killed Bots',
            'killed_beasts' => 'Killed Beasts',
            'use_potions' => 'Use Potions',
        );
    }

    /**
     * Добавляет в статистику показатели
     * @param type $type
     */
    public static function addToStatistic ($type) {
        if (isset(Yii::app()->user)) {
            $statistic = self::model()->findByPk(Yii::app()->user->id);
            if (!$statistic) {
                $statistic = new UserStatistic();
                $statistic->id_user = Yii::app()->user->id;
                $statistic->$type += 1;
                $statistic->save(false);
            }
            $statistic->saveCounters([$type=>1]);
        }
        return true;
    }

    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_user', $this->id_user, true);
        $criteria->compare('killed_users', $this->killed_users, true);
        $criteria->compare('killed_bots', $this->killed_bots, true);
        $criteria->compare('killed_beasts', $this->killed_beasts, true);
        $criteria->compare('use_potions', $this->use_potions, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return UserStatistic the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
