<?php

class UserItems extends CActiveRecord {

    public $price;
    public $user;
    public $sum;
    public $better;
	public $id_set;

    public function tableName() {
        return 'user_items';
    }

    public function rules() {
        return array(
            array('id_item, id_user, name, type, quality, level, strength, armor, health, energy, regeneration, shop_id, id_set', 'safe'),
        );
    }

    public function relations() {
        return array(
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
            'idItem' => array(self::BELONGS_TO, 'ShopItems', 'shop_id'),
        );
    }

    public function attributeLabels() {
        return array(
        );
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    /**
     * Проверяет есть ли поломаные вещи
     * @return type
     */
    public static function checkForItemsHardness() {
        $criteria = new CDbCriteria;
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->compare('hardness', 0);
        $criteria->compare('status', ITEM_ON_BODY);
        return self::model()->count($criteria);
    }
    
    /**
     * Проверяет есть ли вещь лучше
     * @return type
     */
    public static function checkForBetterItem() {
        $criteria = new CDbCriteria;
        $criteria->select = array('id_item', 'type', '(strength+energy+regeneration+health+armor+enchant_strength+enchant_energy+enchant_regeneration+enchant_health+enchant_armor) as sum');
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->compare('status', ITEM_IN_BACKPACK);
        $user_items = self::model()->findAll($criteria);
        if ($user_items) {
            foreach ($user_items as $item) {
                $user_item = self::findUserItem($item);
                if (!$user_item || $item->sum > $user_item->sum)
                    return true;
            }
        }
        return false;
    }
    /**
     * Считает сколько железа необходимо для починки вещей
     * @return type
     */
    public static function countSummaryHardness() {
        $summary = 0;
        $criteria = new CDbCriteria;
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->addCondition('hardness < hardness_max');
        $criteria->compare('status', ITEM_ON_BODY);
        $items = self::model()->findAll($criteria);
        foreach ($items as $item) {
            $summary += $item->hardness_max-$item->hardness;
        }
        return $summary;
    }
    
    /**
     * Выводит обьект вещи
     * @param type $id_item
     * @return type
     */
    public static function findItem($id_item) {
        $criteria = new CDbCriteria;
        $criteria->select = array('*', '(strength+energy+regeneration+health+armor+enchant_strength+enchant_energy+enchant_regeneration+enchant_health+enchant_armor) as sum');
        $criteria->compare('id_item', $id_item);
        return self::model()->find($criteria);
    }
    
    /**
     * Выводит обьект вещи юзера аналогичной просматриваемой
     * @param type $item
     * @return type
     */
    public static function findUserItem($item) {
        if ($item->id_item) {
            $criteria = new CDbCriteria;
            $criteria->select = array('*', '(strength+energy+regeneration+health+armor+enchant_strength+enchant_energy+enchant_regeneration+enchant_health+enchant_armor) as sum');
            $criteria->condition = 'id_item !='.$item->id_item;
            $criteria->compare('id_user', Yii::app()->user->id);
            $criteria->compare('type', $item->type);
            $criteria->compare('status', ITEM_ON_BODY);
            return self::model()->find($criteria);
        }
        else {
            return new UserItems;
        }
    }
    
    /**
     * Возврашает имя вещи
     * @param type $id_item
     * @param type $type вовращает с ссылкой или нет
     * @return type
     */
    public static function itemName($id_item, $type=1) {
        $criteria = new CDbCriteria;
        $criteria->select = (array('id_item', 'name', 'quality', 'enchant_type'));
        $criteria->compare('id_item', $id_item);
        $item = self::model()->find($criteria);

        if (!isset($item->name)) {
            return '<span class="quality-0">предмет</span>';
        }
        
        if ($type==1) 
            $name = CHtml::link($item->name, array('/item/index', 'id' => $item->id_item), array('class' => 'quality-'.$item->quality));
        else 
            $name='<span class="quality-'.$item->quality.'">'.$item->name.'</span>';
        if ($item->enchant_type)
            $name .= '<img src="/images/icons/quality/'.$item->enchant_type.'.png" alt="*"/>';
        return '<img src="/images/icons/quality/'.$item->quality.'.png" alt="*"/> '.$name;
    }
    
    /**
     * Выводит инфо по чарам
     * @param type $id_item
     * @return type
     */
    public static function enchantInfo($id_item) {
        $array = array('enchant_health' => 'здоровья', 'enchant_energy' => 'энергии', 'enchant_strength' => 'силы', 'enchant_armor' => 'брони', 'enchant_regeneration' => 'регенерации');
        $criteria = new CDbCriteria;
        $criteria->select = (array('id_item', 'enchant_type', 'enchant_health', 'enchant_energy', 'enchant_strength', 'enchant_armor', 'enchant_regeneration'));
        $criteria->compare('id_item', $id_item);
        $item = self::model()->find($criteria);

        if ($item->enchant_type) {
            foreach ($array as $value => $name) {
                if ($item->$value) {
                    return '+'.$item->$value.' '.$name;
                }
            }
        }
        return false;
    }

    public static function calcParam($value, $id_item) {
        $criteria = new CDbCriteria;
        $criteria->select = array($value);
        $criteria->compare('id_item', $id_item);
        $item = self::model()->find($criteria);
        return $item->$value;
    }
    
    /**
     * Считает сумму статов по типу вещи для фильтра аука 
     * @param type $type
     * @return type
     */
    public static function calcAllParamsByType($type) {
        $criteria = new CDbCriteria;
        $criteria->select = array('(strength+energy+regeneration+health+armor+enchant_strength+enchant_energy+enchant_regeneration+enchant_health+enchant_armor) as sum');
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->compare('type', $type);
        $criteria->compare('status', ITEM_ON_BODY);
        $user_item = self::model()->find($criteria);       
        return ($user_item ? $user_item->sum : 0);
    }
    
    public static function checkOwner($id_item, $check_personal = false) {
        $criteria = new CDbCriteria;
        $criteria->compare('id_item', $id_item);
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->addInCondition('status', array(ITEM_IN_BACKPACK, ITEM_IN_STORE));   
        if ($check_personal) {
            $criteria->addCondition('personal = 0');
        }
        return self::model()->count($criteria);
    }
    
    /**
     * Проверяет надета ли вещь на данного юзера
     * @param type $id_item
     * @return type
     */
    public static function checkBodyItem($id_item) {
        $criteria = new CDbCriteria;
        $criteria->compare('id_item', $id_item);
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->compare('status', ITEM_ON_BODY);   
        return self::model()->count($criteria);
    }
    
    /**
     * Возвращает массив со случайно выбранной одетой вещью, нужно для поломок
     * @param type $id_user ID юзера, по которому удар
     * @return type
     */
    public static function getRandomItem($id_user) {
        $criteria = new CDbCriteria;
        $criteria->compare('id_user', $id_user);
        $criteria->compare('status', ITEM_ON_BODY);
        $criteria->order = 'RAND()';
        $criteria->limit = 1;
        return self::model()->find($criteria);
    }
}
