<?php

/**
 * This is the model class for table "user_dungeons".
 *
 * The followings are the available columns in table 'user_dungeons':
 * @property string $id_user
 * @property string $id_dungeon
 * @property string $time_last
 * @property string $nubmer
 */
class UserDungeons extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'user_dungeons';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id_user, id_dungeon, time_last', 'required'),
            array('id_user, id_dungeon, time_last', 'length', 'max' => 11),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id_user, id_dungeon, time_last', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_user' => 'Id User',
            'id_dungeon' => 'Id Dungeon',
            'time_last' => 'Time Last',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_user', $this->id_user, true);
        $criteria->compare('id_dungeon', $this->id_dungeon, true);
        $criteria->compare('time_last', $this->time_last, true);
        $criteria->compare('nubmer', $this->nubmer, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return UserDungeons the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * Проверяет был ли юзер уже в этом данже, и устанавливаем время след. входа
     * @param type $id_user
     * @param type $dungeon
     * @throws CHttpException
     */
    public static function checkHistory($id_user, $dungeon) {
        $history = self::model()->findByPk(array('id_user'=>$id_user, 'id_dungeon'=>$dungeon->id_dungeon));
        if (count($history) > 0) {
            $history->time_last = time()+$dungeon->idDungeon->time_cooldown;
        }
        else {
            $history = new UserDungeons();
            $history->id_user = $id_user;
            $history->id_dungeon = $dungeon->id_dungeon;
            $history->time_last = time()+$dungeon->idDungeon->time_cooldown;
        }
        if (!$history->save(false)) {
            throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении истории боя!'));
        }
    }
}
