<?php
class UserDaily extends CActiveRecord {

    public function tableName() {
        return 'user_daily';
    }

    public function rules() {
        return array(
            array('id_user', 'required'),
            array('ironmaster', 'numerical', 'integerOnly' => true),
            array('id_user', 'length', 'max' => 11),
            array('bonus, ironmaster', 'safe'),
            array('id_user, ironmaster', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
        );
    }

    public function attributeLabels() {
        return array(
            'id_user' => 'Id User',
            'ironmaster' => 'Ironmaster',
        );
    }

    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_user', $this->id_user, true);
        $criteria->compare('ironmaster', $this->ironmaster);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Добавляет в ежедневку запись
     * @param type $type
     */
    public static function addToDaily ($type) {
        if (isset(Yii::app()->user)) {
            $daily = self::model()->findByPk(Yii::app()->user->id);
            if (!$daily) 
                $daily = new UserDaily();
            $daily->id_user = Yii::app()->user->id;
            $daily->$type += 1;
            $daily->save(false);
        }
        return true;
    }
    
    /**
     * Проверяет ежедневку
     * @param type $type
     */
    public static function check ($type, $value = 1) {
        return self::model()->countByAttributes(array('id_user'=>Yii::app()->user->id, $type=>$value));
    }
    
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
