<?php

/**
 * This is the model class for table "user_ban".
 *
 * The followings are the available columns in table 'user_ban':
 * @property string $id_ban
 * @property string $id_user
 * @property string $id_admin
 * @property string $reason
 * @property string $time
 *
 * The followings are the available model relations:
 * @property Users $idUser
 */
class UserBan extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'user_ban';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id_user, reason, time', 'required'),
            array('id_user, id_admin, time', 'length', 'max' => 11),
            array('reason', 'length', 'max' => 256),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id_ban, id_user, id_admin, reason, time', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
            'idAdmin' => array(self::BELONGS_TO, 'Users', 'id_admin'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_ban' => 'Id Ban',
            'id_user' => 'Нарушитель',
            'id_admin' => 'Администратор',
            'reason' => 'Причина',
            'time' => 'Время',
        );
    }

    protected function beforeSave() {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                $this->id_admin = Yii::app()->user->id;
            }
            return true;
        } else {
            return false;
        }
    }
    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_ban', $this->id_ban, true);
        $criteria->compare('id_user', $this->id_user, true);
        $criteria->compare('id_admin', $this->id_admin, true);
        $criteria->compare('reason', $this->reason, true);
        $criteria->compare('time', $this->time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return UserBan the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
