<?php
class Top extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'top';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type, id_user, value', 'required'),
            array('type, value', 'numerical', 'integerOnly' => true),
            array('id_user', 'length', 'max' => 11),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id_top, type, id_user, value', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id_top' => 'Id Top',
            'type' => 'Type',
            'id_user' => 'Id User',
            'value' => 'Value',
        );
    }

    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id_top', $this->id_top, true);
        $criteria->compare('type', $this->type);
        $criteria->compare('id_user', $this->id_user, true);
        $criteria->compare('value', $this->value);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Top the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
