<?php
class SupportMessages extends CActiveRecord {

    public function tableName() {
        return 'support_messages';
    }

    public function rules() {
        return array(
            array('id_category, message', 'required'),
            array('answer', 'required', 'on'=>'update'),
            array('id_category, id_user, time', 'length', 'max' => 11),
            array('id_user, time, id_admin', 'safe'),
            array('id_message, id_category, id_user, message, time', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'idCategory' => array(self::BELONGS_TO, 'SupportCategories', 'id_category'),
            'idUser' => array(self::BELONGS_TO, 'Users', 'id_user'),
        );
    }

    public function attributeLabels() {
        return array(
            'id_message' => 'Id Message',
            'id_category' => 'Тип запроса',
            'id_user' => 'Игрок',
            'message' => 'Текст запроса',
			'answer' => 'Ответ',
            'status' => 'Статус',
            'time' => 'Дата',
        );
    }

    protected function beforeSave() {
        if ($this->isNewRecord) {
            $this->time = time();
            $this->id_user = Yii::app()->user->id;
        }
		else {
			$this->id_admin = Yii::app()->user->id;
			$this->status = 1;
		}
        return parent::beforeSave();
    }
    
    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_message', $this->id_message, true);
        $criteria->compare('id_category', $this->id_category, true);
        $criteria->compare('id_user', $this->id_user, true);
        $criteria->compare('message', $this->message, true);
        $criteria->compare('time', $this->time, true);
        $criteria->compare('status', $this->status, true);
        $criteria->order = 'time DESC';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }
    
    public function getColumns() {
        return array(
            array(
                'name' => 'id_message',
                'header' => '#',
            ),
            array(
                'name' => 'message',
                'type' => 'raw',
                'htmlOptions' => array('class'=>'w_35p')
            ),
            array(
                'name' => 'id_user',
                'type' => 'raw',
                'value' => 'Users::getLoginWithLink($data->id_user)',
            ),
            array(
                'name' => 'time',
                'value' => 'FuncHelper::time($data->time)',
            ),
            array(
                'name' => 'status',
				'value' => '($data->status > 0 ? "Ответ получен" : "Новый запрос")',
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{answer}{delete}',
                'buttons' => array(
                    'answer' => array(
                        'url' => 'array("support/answer", "id"=>$data->id_message)',
                        'label' => '<i class="fa fa-reply-all"></i>',
                        'options' => array('title'=>'Ответить', 'style'=>'color: #000000;'),
						'visible'=>'$data->status<1?true:false'
                    ),
                )
            )
        );
    }
    
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function checkForNewMessage() {
        $criteria = new CDbCriteria;
        $criteria->compare('id_user', Yii::app()->user->id);
        $criteria->compare('status', 0);
        return self::model()->count($criteria);
    }
}
