<?php
class SupportCategories extends CActiveRecord {

    public function tableName() {
        return 'support_categories';
    }

    public function rules() {
        return array(
            array('title, description', 'required'),
            array('title, description', 'length', 'max' => 255),
            array('id_category, title, description', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'supportMessages' => array(self::HAS_MANY, 'SupportMessages', 'id_category'),
        );
    }

    public function attributeLabels() {
        return array(
            'id_category' => 'Id Category',
            'title' => 'Title',
            'description' => 'Description',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;
        $criteria->compare('id_category', $this->id_category, true);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('description', $this->description, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
