<?php

/**
 * The followings are the available columns in table 'users':
 */
class ShopItems extends CActiveRecord {

    public $price;
    public $sum;
    public $img;
    public $quality;
    public $better;
    public $strength_percent;
    public $armor_percent;
    public $health_percent;
    public $energy_percent;
    public $regeneration_percent;
    public $enchant_type;
    public $personal;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'shop_items';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id_item, id_set, name, type, level, strength, armor, health, energy, regeneration, better, sum, img, quality', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'idSet' => array(self::BELONGS_TO, 'ShopSets', 'id_set'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
        );
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Users the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function findAllBySet($id_set) {
        $id_set = (int)$id_set;
        return self::model()->findAllByAttributes(array('id_set'=>$id_set));
    }
    
    public static function getPercents($quality) {
        $min = array(0, 25, 50, 75, 100, 150, 200);
        $min = array(0, 49, 74, 99, 149, 199, 299);
        $result = array('min' => $min[$quality], 'max' => $max[$quality]);
        return $result;
    }

    public static function getItemHardness($level, $quality) {
        $hardness = array();
        if ($level > 24) {
            $hardness = array(1 =>15, 180, 255, 400, 625, 900);
        } elseif ($level > 19) {
            $hardness = array(1 =>15, 77, 111, 198, 310, 700);
        } elseif ($level > 14) {
            $hardness = array(1 =>15, 35, 50, 98, 155, 222);
        } elseif ($level > 9) {
            $hardness = array(1 => 12, 24, 29, 49);
        } elseif ($level > 4) {
            $hardness = array(1 => 14, 19, 20);
        }
        else {
            $hardness = array(1 => 10, 10, 10, 10, 10, 10);
        }
        $result = ($hardness[$quality] > 0 ? $hardness[$quality] : 1);
        return $result;
    }

    /**
     * Выводит обьект вещи
     * @param type $id_item
     * @return type
     */
    public static function findItem($id_item) {
        $criteria = new CDbCriteria;
        $criteria->select = array('*, (strength+energy+regeneration+health+armor) as sum');
        $criteria->compare('id_item', $id_item);
        return self::model()->find($criteria);
    }
    
    /**
     * Выдает вещь юзеру
     * @param int $id_item ИД вещи в магазине
     * @param int $quality качество вещи
     * @param int $id_user кому выдать
     * @param boolean $buyItem вещь куплена в магазине или выпала
     * @param boolean $on_body одевать сразу вещь или нет
     * @param boolean $personal персональная вещь или нет
     * @return int ID вещи
     * @throws CHttpException
     */
    public static function getNewItem($id_item, $quality, $id_user, $buyItem = true, $on_body = false, $personal = false) {
        //Выбираем шмотку из магазина
        $shop_item = self::model()->findByPK($id_item);
        $user = Users::model()->findByPK($id_user);

        $user_item = new UserItems();
        //Парочку параметров все же возьму так
        $user_item->attributes = $shop_item->attributes;
        //Поля совпадают, поэтому надо сделать так
        unset($user_item->id_item);
        //Заносим данные
        $user_item->shop_id = $shop_item->id_item;
        $user_item->id_user = $id_user;
        $user_item->quality = $quality;
        $user_item->img = $shop_item->id_set . '/' . $shop_item->type;
        if ($personal)
            $user_item->personal = 1;
        //Устанавливаем прочность
        $user_item->hardness = $user_item->hardness_max = self::getItemHardness($shop_item->level, $quality);

        if ($buyItem) {
            //Массив с стандартными процентами в магазине
            $qualities = array(3 => 99, 140, 195, 275);
            $quality_value = $qualities[$quality];
        } else {
            if ($quality < 1) {
                $rand['min'] = 0;
                $rand['max'] = 0;
            } elseif ($quality < 2) {
                $rand['min'] = 25;
                $rand['max'] = 49;
            } elseif ($quality < 3) {
                $rand['min'] = 50;
                $rand['max'] = 74;
            } elseif ($quality < 4) {
                $rand['min'] = 75;
                $rand['max'] = 99;
            } elseif ($quality < 5) {
                $rand['min'] = 100;
                $rand['max'] = 149;
            } elseif ($quality < 6) {
                $rand['min'] = 150;
                $rand['max'] = 199;
            } elseif ($quality < 7) {
                $rand['min'] = 200;
                $rand['max'] = 299;
            }
        }

        //Подсчитаем статы и занесем вместе с процентами
        $params = array('strength', 'energy', 'regeneration', 'health', 'armor');
        foreach ($params as $param) {
            if (!$buyItem) {
                $quality_value = rand($rand['min'], $rand['max']);
            }
            if ($shop_item->$param > 0) {
                $percent = $param . '_percent';
                $user_item->$param = self::calcParam($shop_item->id_item, $param, $quality_value);
                $user_item->$percent = $quality_value;
            }
        }

        if ($user->backpack_destroy >= $quality) {
            $user->iron += $user_item->hardness;
            $user_item->status = ITEM_DESTROY;
            if (!$user->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при сохранении пользователя!'));
            }
            if (!$user_item->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при покупке товара!'));
            }
        }
        elseif ($on_body == true) {
            //Если бот - сразу же одеваем вещь
            $user_item->status = ITEM_ON_BODY;
            if (!$user_item->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при покупке товара!'));
            }
        }
        elseif (!$buyItem && UserItems::model()->countByAttributes(array('id_user'=> $id_user, 'status'=> ITEM_IN_BACKPACK)) < $user->backpack) {
            //Ложим вещь в рюкзак
            $user_item->status = ITEM_IN_BACKPACK;
            if (!$user_item->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при покупке товара!'));
            }
        }
        else {
            //Отправляем на почту новую вещь с магазина
            $user_item->status = ITEM_IN_MAIL;
            if (!$user_item->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при покупке товара!'));
            }
            
            $id_dialog = Users::checkDialog($id_user, 100);
            $mail = new UsersMessages();
            $mail->id_dialog = $id_dialog;
            $mail->id_user = 100;
            $mail->users = $id_user;
            $mail->type = 3;
            $mail->message = 'Посылка (предмет)';
            $mail->item = $user_item->id_item;
            if (!$mail->save(false)) {
                throw new CHttpException(500, Yii::t('layout', 'Ошибка при отправке почты!'));
            }
        }
        return $user_item->id_item;
    }

    public static function calcParam($id_item, $param, $percent) {
        $criteria = new CDbCriteria;
        $criteria->select = array($param);
        $criteria->compare('id_item', $id_item);
        $shop = self::model()->find($criteria);
        $result = round($shop[$param] + ($shop[$param] / 100) * $percent);
        return $result;
    }

    /**
     * Возвращает ид случайной вещи для дропа в Битвах
     * @param type $location массив с локацией
     * @return type
     */
    public static function getRandomItemInBattles($location) {
        if ($location->level_min >= 20) {
            $location->level_min = 20;
            $location->level_max = 25;
        }
        $criteria = new CDbCriteria();
        $criteria->condition = 'id_set < 9';
        $criteria->select = array('id_item', 'id_set');
        $criteria->addBetweenCondition('level', $location->level_min, $location->level_max);
        $criteria->order = 'RAND()';
        $criteria->limit = 1;
        return self::model()->find($criteria);
    }

    /**
     * Возвращает ид случайной вещи для дропа в Пещерах
     * @param type $id_set - ид сета
     * @param type $personal - личная или нет
     * @return type
     */
    public static function getRandomItemInDungeons($id_set) {
        $criteria = new CDbCriteria();
        $criteria->condition = 'id_set = '.$id_set;
        $criteria->select = array('id_item', 'id_set');
        $criteria->order = 'RAND()';
        $criteria->limit = 1;
        return self::model()->find($criteria);
    }
}
