<?php

class ShopAvatars extends CActiveRecord {

    public $image;

    public function tableName() {
        return 'shop_avatars';
    }

    public function rules() {
        return array(
            array('price, count', 'length', 'max' => 11),
            array('id_avatar, price, count', 'safe'),
            array('image', 'EImageValidator',
                'allowEmpty' => 'true',
                'types' => "jpg",
                'width'=> 65,
                'height'=> 65
            ),
        );
    }

    public function relations() {
        return array(
        );
    }

    public function attributeLabels() {
        return array(
            'id_avatar' => 'Id Avatar',
            'price' => 'Цена в серебре',
            'count' => 'Count',
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

        $criteria->compare('id_avatar', $this->id_avatar);
        $criteria->compare('price', $this->price, true);
        $criteria->compare('count', $this->count, true);
        $criteria->order = 'id_avatar ASC';
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getColumns() {
        return array(
            array(
                'name' => 'id_avatar',
                'header' => '#',
            ),
            array(
                'header' => 'Аватар',
                'type' => 'raw',
                'value' => function ($data) {
                    return '<img src="/images/avatars/'.$data->id_avatar.'.jpg" alt="*">';
                },
            ),
            array(
                'name' => 'price',
                'type' => 'raw',
                'header' => 'Цена',
                'value' => function ($data) {
                    return FuncHelper::money($data->price);
                },
            ),
            array(
                'name' => 'count',
                'header' => 'Кол-во установок',
            ),
            array(
                'class' => 'CButtonColumn',
                'template' => '{control}{remove}',
                'buttons' => array(
                    'control' => array(
                        'url' => 'array("shop/updateAvatar", "id"=>$data->id_avatar)',
                        'label' => '<i class="fa fa-pencil"></i>',
                        'options' => array('title' => 'Редактировать', 'style' => 'color: #000000;', 'class' => 'getForm'),
                    ),
                    'remove' => array(
                        'url' => 'array("shop/deleteAvatar", "id"=>$data->id_avatar)',
                        'label' => '<i class="fa fa-times"></i>',
                        'options' => array(
                            'title' => 'Удалить', 
                            'style' => 'color: #000000;',
                            'confirm' => 'Удалить аватар?',
                            'ajax' => array(
                                'type' => 'POST',
                                'url' => "js:$(this).attr('href')",
                                'success' => 'function(data){                                
                                if(data == "true"){
                                    $.fn.yiiGridView.update("avatars-grid");
                                    return false;
                                }
                            }',
                            'error' => 'function(data) { alert("error"); }',
                            ),
                        ),
                    )
                )
            )
        );
    }

}
