<?php

class ShopAbilities extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'shop_abilities';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name_ability, descr_ability, passive_ability', 'required'),
			array('name_ability', 'length', 'max'=>64),
			array('descr_ability, passive_ability', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_ability, name_ability, descr_ability, passive_ability', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'abilitiesTypes' => array(self::HAS_MANY, 'ShopAbilitiesTypes', 'id_ability'),
			'bestType' => array(self::HAS_ONE, 'ShopAbilitiesTypes', 'id_ability', 'order' => 'id_type DESC'),
			'usersAbilities' => array(self::HAS_MANY, 'UsersAbilities', 'id_ability'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_ability' => 'Id Ability',
			'name_ability' => 'Name Ability',
			'descr_ability' => 'Descr Ability',
			'passive_ability' => 'Passive Ability',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_ability',$this->id_ability,true);
		$criteria->compare('name_ability',$this->name_ability,true);
		$criteria->compare('descr_ability',$this->descr_ability,true);
		$criteria->compare('passive_ability',$this->passive_ability,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ShopAbilities the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
