<?php
class SaveForm extends CFormModel
{
    public $sex;
    public $password;
    public $password_confirm;
    public $login;
    public $email;

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules()
    {
        $rules = array(
            array('login', 'length', 'min' => 3, 'max' => 16, 'tooShort' => 'Логин должен быть длиной от 3 до 16 символов', 'tooLong' => 'Логин должен быть длиной от 3 до 16 символов'),
            array('login', 'match', 'pattern'=>'/^[а-яА-ЯёЁa-zA-Z][а-яА-ЯёЁa-zA-Z0-9-_\s]{3,16}$/u', 'allowEmpty'=>false, 'message' => Yii::t('layout', 'Логин содержит запрещенные символы')),
            array('login', 'unique', 'className' => 'Users', 'caseSensitive' => false, 'message' => Yii::t('layout', 'Такой логин уже существует')),
            array('sex, password_confirm', 'safe'),
        );
        if (!isset($_SERVER['HTTP_X_HOST'])) {
            $all_rules = array(
                array('password', 'length', 'max'=>32, 'min' => 4,'message' => Yii::t('layout', 'Длина пароля должна быть от 4 до 32 символов')),
                array('password', 'compare', 'compareAttribute'=>'password_confirm'),
                array('email', 'email'),
                array('email', 'unique', 'className' => 'Users', 'caseSensitive' => false, 'message' => Yii::t('layout', 'Такой email уже существует')),
            );
            $rules = array_merge($rules, $all_rules);
        }
        return $rules;
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels()
    {
        return array(
            'password' => Yii::t('admin_layout','Ваш пароль'),
            'password_confirm' => Yii::t('admin_layout','Повторите пароль'),
            'login'=>Yii::t('admin_layout','Новый логин'),
            'sex'=>Yii::t('admin_layout','Ваш пол'),
            'email'=>Yii::t('admin_layout','Ваш email (для восстановления пароля)'),
        );
    }
}
