<?php

/**
 * This is the model class for table "role_categories".
 *
 * The followings are the available columns in table 'role_categories':
 * @property string $id_cat_role
 * @property string $name_cat_ru
 * @property string $name_cat_ua
 *
 * The followings are the available model relations:
 * @property Roles[] $roles
 */
class RoleCategories extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'role_categories';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name_cat_ru, name_cat_ua', 'required'),
			array('name_cat_ru, name_cat_ua', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id_cat_role, name_cat_ru, name_cat_ua', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'roles' => array(self::HAS_MANY, 'Roles', 'id_cat_role'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cat_role' => 'Id Cat Role',
			'name_cat_ru' => 'Name Cat Ru',
			'name_cat_ua' => 'Name Cat Ua',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cat_role',$this->id_cat_role);
		$criteria->compare('name_cat_ru',$this->name_cat_ru,true);
		$criteria->compare('name_cat_ua',$this->name_cat_ua,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return RoleCategories the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public static function findAllExceptGuestsAndSuperAdmins()
        {
            return self::model()->findAll(array('condition' => 'id_cat_role NOT IN (4,5)'));
        }
        
        public static function findAllExceptGuestsAndPlayers()
        {
            return self::model()->findAll(array('condition' => 'id_cat_role NOT IN (4,5)'));
        }
        
        /**
         * Проверяет на роль админов
         * @param int $role_cat роль подьзователя
         * @return boolean
         */
        public static function checkRoleForAdmins($role_cat)
        {
            $roles = array(2, 3, 5);
            if (in_array($role_cat, $roles))
                return true;
            else
                return false;
        }
}
