<?php
class RemindForm extends CFormModel {
    public $login;
    public $email;

    public function rules() {
        return array(
            array('login', 'required'),
            array('login', 'checkForEmail'),
        );
    }
    
    public function attributeLabels() {
        return array(
            'login' => Yii::t('admin_layout', 'Игровое имя (Ник)'),
        );
    }

    public function checkForEmail($attribute, $params) {
        $user = Users::model()->findByAttributes(array('login'=>$this->$attribute));
        if ($user) {
            if (!$user->email) {
                $this->addError($attribute, Yii::t('layout', 'Для данного логина не указан Email!'));
            }
            elseif ($user->email && $user->email_remind_time > (time()-60*60*24)) {
                $this->addError($attribute, Yii::t('layout', 'Вам уже было отправленно сообщение на Email!'));
            }
        }
        else
            $this->addError($attribute, Yii::t('layout', 'Данный логин не существует!'));
    }
}
