<?php
class RegistrationForm extends CFormModel {

    public $login;
    public $password;
    public $confirm;
    public $class;
    public $sex;
    public $side;
    public $verifyCode;
    
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        $arr_rules = array(   
            array('login, password, confirm, sex, side, class', 'required'),
            array('login', 'length', 'max'=>20, 'min' => 3,'message' => Yii::t('client_layout', 'Длина ника должна быть от 3 до 20 символов')),
            array('password', 'length', 'max'=>32, 'min' => 4,'message' => Yii::t('client_layout', 'Длина пароля должна быть от 4 до 32 символов')),
            array('login', 'match', 'pattern' => '#^[a-zA-Z0-9_\.-]+$#', 'message' => Yii::t('client_layout', 'Hик содержит запрещённые символы')),
            array('login', 'unique', 'className' => 'Users', 'caseSensitive' => false, 'message' => Yii::t('client_layout', 'Такой ник уже существует')),
            array('confirm', 'compare', 'compareAttribute' => 'password', 'message' => Yii::t('client_layout', 'Пароли не совпадают')),
            array('', 'safe'),
        );
        /*
        if (Yii::App()->params['departments']) {
            $arr_rules[] = array('id_dep', 'required');
        }

        if (Yii::App()->params['positions']) {
            $arr_rules[] = array('id_pos', 'required');
        }
        */
        return $arr_rules;       
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'login' => Yii::t('client_layout', 'Игровое имя (Ник)'),
            'password' => Yii::t('client_layout', 'Пароль'),
            'confirm' => Yii::t('client_layout', 'Подтвердите пароль'),
            'sex' => Yii::t('client_layout', 'Ваш пол'),
            'side' => Yii::t('client_layout', 'Ваша сторона'),
            'class' => Yii::t('client_layout', 'Ваш класс'),
            'verifyCode' => Yii::t('admin_layout','Код проверки'),
        );
    }

}

?>