<?php
class PaymentForm extends CFormModel
{
    public $phone;
    public $number;
    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('number, phone', 'required', 'on'=>'mobilePayment'),
            array('number, phone', 'numerical', 'integerOnly'=>true),
            array('phone', 'length', 'max'=>11),
            array('type', 'checkFields', 'on'=>'insert'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('resource', 'safe'),
        );
    }
    
    public function checkFields($attribute, $params) {
        if ($this->type == 1) {
            $this->money = $this->gold*100+$this->silver+$percent;
            $percent = (round($this->money/20)>5 ? round($this->money/20) : 5);
            $this->money += $percent;
            if (!$this->gold && !$this->silver)
                $this->addError('money', Yii::t('layout', 'Укажите сумму для отправки'));
            if (!Users::checkForAvailable('money', $this->money))
                $this->addError('money', Yii::t('layout', 'У Вас нет столько денег'));
        }
        elseif ($this->type == 2) {
            $price = 5*round($this->number/($this->resource == 'iron' ? 10000 : 10));
            if (!$this->resource && !$this->number)
                $this->addError('number', Yii::t('layout', 'Укажите количество ресурсов для отправки'));
            if (!Users::checkForAvailable($this->resource, $this->number))
                $this->addError('number', Yii::t('layout', 'У вас нет столько ресурсов'));
            if (!Users::checkForAvailable('money', $price))
                $this->addError('number', Yii::t('layout', 'Недостаточно денег для оплаты сообщения'));
        }
        elseif ($this->type == 3) {
            if (!$this->items)
                $this->addError('items', Yii::t('layout', 'Выберите предмет для отправки'));
            if (!UserItems::checkOwner($this->items))
                $this->addError('items', Yii::t('layout', 'Выберите другой предмет для отправки'));
            if (!Users::checkForAvailable('money', 5))
                $this->addError('number', Yii::t('layout', 'Недостаточно денег для оплаты сообщения'));
        }
        else {
            if (!$this->text) {
                $this->addError('text', Yii::t('layout', 'Необходимо ввести текст сообщения'));
            }
            if (!Users::checkForAvailable('iron', 1))
                $this->addError('number', Yii::t('layout', 'Недостаточно железа для оплаты сообщения'));
        }
    }
    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(		
            'phone' => Yii::t('layout', 'Ваш номер телефона (Россия)'),
            'number' => Yii::t('layout', 'Количество золота'),
        );
    }
}
